<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:sc="http://www.utc.fr/ics/scenari/v3/core"
	xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" xmlns:mss="utc.fr:simpleSlideShow"
	xmlns:of="scpf.org:office" xmlns:xalan="http://xml.apache.org/xalan"
	exclude-result-prefixes="mss xalan">

	<xsl:include href="utils.xsl"/>

	<xsl:output encoding="UTF-8" indent="yes" method="xml"/>

	<xsl:strip-space elements="*"/>

	<xsl:template match="/sc:item">
		<sc:item>
			<xsl:apply-templates/>
		</sc:item>
	</xsl:template>

	<xsl:template match="mss:simpleSlideShow">
		<of:slideshow>
			<xsl:apply-templates/>
		</of:slideshow>
	</xsl:template>

	<xsl:template match="mss:sssMeta">
		<of:slideshowM>
			<xsl:apply-templates/>
		</of:slideshowM>
	</xsl:template>

	<xsl:template match="mss:sssMeta/sp:title">
		<sp:title>
			<xsl:value-of select="."/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:sssMeta/*" priority="0"/>

	<xsl:template match="mss:simpleSlideShow/sp:part">
		<sp:part>
			<xsl:apply-templates/>
		</sp:part>
	</xsl:template>

	<xsl:template match="mss:part">
		<of:slideshow>
			<xsl:apply-templates/>
		</of:slideshow>
	</xsl:template>

	<xsl:template match="mss:part/mss:title">
		<of:slideshowM>
			<xsl:apply-templates/>
		</of:slideshowM>
	</xsl:template>

	<xsl:template match="mss:title/sc:fullTitle">
		<sp:title>
			<xsl:value-of select="."/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:part/mss:title/*" priority="0"/>

	<xsl:template match="mss:part/sp:summary">
		<sp:slide>
			<of:section>
				<of:sectionM/>
				<sp:content>
					<of:fragment>
						<sp:info>
							<of:block>
								<of:blockM/>
								<sp:co>
									<xsl:apply-templates/>
								</sp:co>
							</of:block>
						</sp:info>
					</of:fragment>
				</sp:content>
			</of:section>
		</sp:slide>
	</xsl:template>

	<xsl:template match="mss:part/sp:summary/mss:text">
		<of:flow>
			<sp:txt>
				<of:txt>
					<xsl:apply-templates select="@*"/>
					<xsl:apply-templates select="node()"/>
				</of:txt>
			</sp:txt>
		</of:flow>
	</xsl:template>

	<xsl:template match="mss:part/sp:page">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">section</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

		<sp:slide sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="sp:page">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">section</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:slide sc:refUri="{$newFilename}"/>
	</xsl:template>

	<!-- Suppression bloc speaker-->
	<xsl:template match="sp:speakerComment">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="sp:speakerComment/mss:comment">
		<!--of:fragment-->
			<xsl:apply-templates/>
		<!--/of:fragment-->
	</xsl:template>

	<xsl:template match="mss:comment/sp:information">
		<!--sp:info>
			<of:block-->
				<xsl:apply-templates/>
			<!--/of:block>
		</sp:info-->
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:comment/sp:information/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:comment/sp:example/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<!--xsl:template match="sp:information/mss:simpleTitle">
		<of:blockM>
			<xsl:apply-templates/>
		</of:blockM>
	</xsl:template-->

	<xsl:template match="mss:comment/sp:information/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:comment/sp:information/mss:simpleTitle/sc:fullTitle/node()">
		<!--sp:title-->
		<xsl:apply-templates/>
		<!--/sp:title-->
	</xsl:template>

	<xsl:template match="mss:comment/sp:information/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:comment/sp:information/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:comment/sp:information/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:information/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:information/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:definition/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:warning/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:example/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:remark/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:flowAll">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:flowAll/sp:text/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:flowAll/sp:text/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:comment/sp:advice/mss:simpleTitle/sc:fullTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<!--Suppression bloc reader-->
	<xsl:template match="sp:readerComment">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="sp:readerComment/mss:comment">
		<!--of:fragment-->
		<xsl:apply-templates/>
		<!--/of:fragment-->
	</xsl:template>
	
	<!--Section-->
	<xsl:template match="mss:section/sp:information/mss:flowAll">
		<sp:co>
			<of:flow>
				<xsl:apply-templates/>
			</of:flow>
		</sp:co>
	</xsl:template>

	<xsl:template match="sp:content/mss:flowAll/sp:text">
		<sp:txt>
			<xsl:apply-templates/>
		</sp:txt>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:text/mss:text">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:text/mss:text/sc:para">
		<sc:para>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sc:para>
	</xsl:template>

	<xsl:template match="mss:compPage/sp:conclusion">
		<sp:sec>
			<of:section>
				<of:sectionM>
					<sp:title>Conclusion</sp:title>
				</of:sectionM>
				<sp:content>
					<of:fragment>
						<sp:info>
							<of:block>
								<of:blockM/>
									<xsl:apply-templates/>				
							</of:block>
						</sp:info>
					</of:fragment>
				</sp:content>
			</of:section>
		</sp:sec>
	</xsl:template>
	
	<xsl:template match="mss:compPage/sp:conclusion/mss:text">
		<sp:co>
			<of:flow>
				<sp:txt>
					<of:txt>
						<xsl:apply-templates/>
					</of:txt>
				</sp:txt>
			</of:flow>
		</sp:co>
	</xsl:template>
	
	<xsl:template match="mss:compPage/sp:conclusion/mss:text/sc:para">
		<sc:para>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sc:para>		
	</xsl:template>
		
		



	<!--MAJ pour les pages composes/diapositives-->
	<xsl:template match="mss:compPage">
		<of:section>
			<xsl:apply-templates/>
		</of:section>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta">
		<of:sectionM>
			<xsl:apply-templates/>
		</of:sectionM>
		<sp:content>
			<of:fragment/>
		</sp:content>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:title">
		<sp:title>
			<xsl:apply-templates/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:shortTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:shortTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:compl">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:compl/sp:urlCompl">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:compPage/mss:pageMeta/sp:compl/sp:urlCompl/node()">
		<xsl:apply-templates/>
	</xsl:template>

	<!-- MAJ pour les sections-->
	<xsl:template match="sp:section">
		<sp:sec>
			<of:section>
				<xsl:apply-templates/>
			</of:section>
		</sp:sec>
	</xsl:template>

	<xsl:template match="sp:section/mss:section">
		<xsl:apply-templates select="mss:simpleTitle"/>
		<sp:content>
			<of:fragment>
				<xsl:apply-templates select="*[not(self::mss:simpleTitle)]"/>
			</of:fragment>
		</sp:content>
	</xsl:template>

	<xsl:template match="mss:section/mss:simpleTitle">
		<of:sectionM>
			<xsl:apply-templates/>
		</of:sectionM>
	</xsl:template>

	<xsl:template match="mss:section/mss:simpleTitle/sc:fullTitle">
		<sp:title>
			<xsl:value-of select="."/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:section/sp:information">
		<sp:info>
			<xsl:apply-templates />
		</sp:info>
	</xsl:template>

	
	<xsl:template match="mss:intentionalBloc[mss:simpleTitle]">
		<of:block>
			<xsl:apply-templates/>
		</of:block>
	</xsl:template>
	
	<xsl:template match="mss:intentionalBloc">
		<of:block>
			<of:blockM />
			<xsl:apply-templates/>
		</of:block>
	</xsl:template>


	<xsl:template match="mss:intentionalBloc/mss:simpleTitle">
		<of:blockM>
			<xsl:apply-templates/>
		</of:blockM>
	</xsl:template>

	<xsl:template match="mss:section/sp:information/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>
			<xsl:value-of select="."/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content">
		<sp:co>
			<xsl:apply-templates/>
		</sp:co>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll">
		<of:flow>
			<sp:txt>
				<of:txt>
					<xsl:apply-templates/>
				</of:txt>
			</sp:txt>
		</of:flow>
	</xsl:template>


	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:text">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:text/sc:para/sc:inlineStyle">
		<sc:inlineStyle role="emphasis">
			<xsl:apply-templates/>
		</sc:inlineStyle>
	</xsl:template>

	<xsl:template match="mss:text/sc:para/sc:uLink">
		<sc:uLink role="url">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sc:uLink>
	</xsl:template>

	<xsl:template match="mss:text/sc:simpleList">
		<sc:itemizedList>
			<xsl:apply-templates/>
		</sc:itemizedList>
	</xsl:template>

	<xsl:template match="mss:text/sc:simpleList/sc:member">
		<sc:listItem>
			<xsl:apply-templates select="@*"/>
			<sc:para><xsl:apply-templates select="node()"/></sc:para>
		</sc:listItem>
	</xsl:template>
	
	<xsl:template match="mss:text/sc:simpleList/sc:member/sc:inlineStyle">
		<sc:inlineStyle role="imp">
			<xsl:apply-templates/>
		</sc:inlineStyle>
	</xsl:template>

	<xsl:template match="mss:text/sc:simpleList/sc:member/sc:uLink">
		<sc:uLink role="url">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sc:uLink>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:image">
		<sc:extBlock role="img">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<xsl:template
		match="mss:intentionalBloc/sp:content/mss:flowAll/sp:image/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:image/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:audio">
		<sc:extBlock role="anim">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:audio/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:audio/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:video">
		<sc:extBlock role="anim">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:video/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:video/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:flash">
		<sc:extBlock role="anim">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<xsl:template
		match="mss:intentionalBloc/sp:content/mss:flowAll/sp:flash/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:flash/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>


	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:table">
		<sc:extBlock role="img">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:table/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:table/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:graphic">
		<xsl:variable name="vExtension">
			<xsl:call-template name="tExtension" >
				<xsl:with-param name="pFilename" select="@sc:refUri" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="vRole">
			<xsl:choose>
				<xsl:when test="$vExtension='swf'">anim</xsl:when>
				<xsl:otherwise>img</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<sc:extBlock role="{$vRole}">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>
	
	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:graphic/mss:simpleTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:graphic/mss:simpleTitle/sc:fullTitle">
		<xsl:apply-templates/>
	</xsl:template>


	<xsl:template match="mss:intentionalBloc/sp:content/mss:flowAll/sp:math">		
		<sc:extBlock role="img">
			<xsl:apply-templates select="@*"/>
		</sc:extBlock>
	</xsl:template>

	<!--Blocs d'insertion textes-->
	<!--Bloc Attention-->
	<xsl:template match="mss:section/sp:warning">
		<sp:emphasis>
			<xsl:apply-templates/>
		</sp:emphasis>
	</xsl:template>

	<!--xsl:template match="sp:warning/mss:intentionalBloc">
		<sp:warn>
			<of:block>
				<xsl:apply-templates/>
			</of:block>
		</sp:warn>
	</xsl:template-->

	<xsl:template match="sp:warning/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>Attention : <xsl:value-of select="."/></sp:title>
	</xsl:template>


	<!--Bloc Remarque-->
	<xsl:template match="mss:section/sp:remark">
		<sp:emphasis>
			<xsl:apply-templates/>
		</sp:emphasis>
	</xsl:template>

	<!--xsl:template match="sp:remark/mss:intentionalBloc">
		<sp:warn>
			<of:block>
				<xsl:apply-templates/>
			</of:block>
		</sp:warn>
	</xsl:template-->

	<xsl:template match="sp:remark/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>
			<xsl:value-of select="."/>
		</sp:title>
	</xsl:template>

	<!--Bloc Dfinition-->
	<xsl:template match="mss:section/sp:definition">
		<sp:extra>
			<xsl:apply-templates/>
		</sp:extra>
	</xsl:template>

	<!--xsl:template match="sp:definition/mss:intentionalBloc">
		<sp:extra>
			<of:block>
				<xsl:apply-templates/>
			</of:block>
		</sp:extra>
	</xsl:template-->

	<xsl:template match="sp:definition/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>Dfinition : <xsl:value-of select="."/></sp:title>
	</xsl:template>


	<!--Bloc Exemple-->
	<xsl:template match="mss:section/sp:example">
		<sp:extra>
			<xsl:apply-templates/>
		</sp:extra>
	</xsl:template>

	<!--xsl:template match="sp:example/mss:intentionalBloc">
		<sp:extra>
			<of:block>
				<xsl:apply-templates/>
			</of:block>
		</sp:extra>
	</xsl:template-->

	<xsl:template match="sp:example/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>Exemple : <xsl:value-of select="."/></sp:title>
	</xsl:template>


	<!--Bloc Conseil-->
	<xsl:template match="mss:section/sp:advice">
		<sp:extra>
			<xsl:apply-templates/>
		</sp:extra>
	</xsl:template>

	<!--xsl:template match="sp:advice/mss:intentionalBloc">
		<sp:extra>
			<of:block>
				<xsl:apply-templates/>
			</of:block>
		</sp:extra>
	</xsl:template-->

	<xsl:template match="sp:advice/mss:intentionalBloc/mss:simpleTitle/sc:fullTitle">
		<sp:title>Conseil : <xsl:value-of select="."/></sp:title>
	</xsl:template>


	<!-- MAJ pour les pages images/galeries-->
	<xsl:template match="mss:picturePage">
		<of:gallery>
			<xsl:apply-templates/>
		</of:gallery>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta">
		<of:galleryM>
			<xsl:apply-templates/>
		</of:galleryM>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta/sp:title">
		<sp:title>
			<xsl:apply-templates/>
		</sp:title>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta/sp:shortTitle">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta/sp:shortTitle/node()">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta/sp:mode">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/mss:pictPageMeta/sp:mode/node()">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:picture">
		<sp:img>
			<xsl:apply-templates select="@*"/>
		</sp:img>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:mainPicture">
		<sp:img>
			<xsl:apply-templates select="@*"/>
		</sp:img>
	</xsl:template>
	
	<!--Suppression conclusion dans galerie images-->
	<xsl:template match="mss:picturePage/sp:conclusion">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:conclusion/mss:text">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:conclusion/mss:text/sc:para">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:conclusion/mss:text/sc:para/node()">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:picturePage/sp:conclusion/mss:text/sc:simpleList">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="mss:picturePage/sp:conclusion/mss:text/sc:simpleList/sc:member">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="mss:picturePage/sp:conclusion/mss:text/sc:simpleList/sc:member/node()">
		<xsl:apply-templates/>
	</xsl:template>


	<xsl:template match="@* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
