<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:sc="http://www.utc.fr/ics/scenari/v3/core"
	xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" 
	xmlns:of="scpf.org:office" xmlns:xalan="http://xml.apache.org/xalan"
	exclude-result-prefixes="xalan">

	<xsl:output encoding="UTF-8" indent="yes" method="xml"/>

	<!--Ajustement des codes .model-->
	<!--fragment : warn devient emphasis-->
	<xsl:template match="of:fragment/sp:warn">
		<sp:emphasis>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sp:emphasis>
	</xsl:template>
	
	<!--Stxt et txt : imp devient emphasis-->
	<xsl:template match="sc:inlineStyle[@role='imp']">
		<sc:inlineStyle role="emphasis">
			<xsl:apply-templates/>
		</sc:inlineStyle>
	</xsl:template>
	
	<!--Gnralisation de terme tranger-->
	<!--foreign devient special-->
	<xsl:template match="sc:textLeaf[@role='foreign']">
		<sc:phrase role="special">
			<xsl:apply-templates/>
		</sc:phrase>
	</xsl:template>
	
	<xsl:template match="node() | @*">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" />
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
