<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" xmlns:redirect="com.scenari.xsldom.xalan.lib.Redirect" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" extension-element-prefixes="redirect" exclude-result-prefixes="sc xhtml" version="1.0">
	<xsl:output omit-xml-declaration="yes" indent="no" method="xml"/>
	<xsl:param name="vDialog"/>
	<xsl:param name="vAgent"/>
	<xsl:template match="treeContent">
		<xsl:if test="count(descendant::entry) &gt; 1">
			<strong class="hidden">￼Navigation générale :￼</strong>
			<ul class="outCat">
				<xsl:apply-templates/>
			</ul>
<hr class="hidden"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="entry">
		<xsl:variable name="vCLass" select="resultatDialogue(concat(@dialog, '/outlineClasses'))"/>
		<xsl:variable name="vUrl" select="resultatDialogue(string(@dialog), 'act:')"/>
		<xsl:variable name="vType" select="returnFirst(root,'ext')"/>
		<xsl:variable name="vLbl" select="si(string-length(@title) &gt; 20,concat(substring(@title,1,18),'…'),@title)"/>
		<xsl:variable name="vTi" select="concat(si(string-length(@title) &gt; 20,concat(@title,si($vType='ext',' - '))),si($vType='ext','￼lien externe￼'))"/>
		<xsl:variable name="vIsSel" select="si(@position = 'current' or @position = 'parent' or @position = 'ancestor',true(),false())"/>
		<li class="outCat_sel_{si($vIsSel, 'yes', 'no')} outCat_typ_{$vType} outCat_{si(entry,'b','l')} {$vCLass}">
			<xsl:choose>
				<xsl:when test="$vIsSel">
					<span class="outCat_i" title="{$vTi}">
						<span>
							<xsl:value-of select="$vLbl"/>
						</span>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<a href="{$vUrl}" target="_self" class="outCat_i outCat_lnk" title="{$vTi}">
						<span>
							<xsl:value-of select="$vLbl"/>
						</span>
					</a>
				</xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	<xsl:template match="node()"/>
</xsl:stylesheet>