<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive"
	xmlns:sc="http://www.utc.fr/ics/scenari/v3/core"
	version="1.0">
	
	<xsl:output method="html" indent="no" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

	<xsl:param name="scPreviewResUrl"/>
	<xsl:param name="scModelUrl"/>
	<xsl:param name="scGenericCssUrl"/>
	<xsl:param name="pAutoPLay"/>

	<xsl:template match="/*">
		<html>
			<head>
				<link rel="stylesheet" href="{$scGenericCssUrl}" type="text/css" />
				<style type="text/css">
					html{
						overflow:hidden;
						font-family:sans-serif;
					}
					.btnPlay, .btnPause{
						text-decoration: none;
						background-repeat:no-repeat;
						background-position:center center;
						opacity:0.4;
					}
					.btnPlay:hover, .btnPause:hover{
						opacity:1;
					}
					.btnPlay span, .btnPause span{
						display:none;
					}
					.btnPlay{
						background-image: url("<xsl:value-of select="$scPreviewResUrl"/>/btnPlay.png");
					}
					.btnPause{
						background-image: url("<xsl:value-of select="$scPreviewResUrl"/>/btnPause.png");
					}
				</style>
				<script type="text/JavaScript">
					var animMgr = {
						init : function(){
							try{
								this.fFra = document.getElementById("animFrame");
								this.fBtn = document.getElementById("animBtn");
								this.fImgs = this.fFra.childNodes;
								if (!this.fImgs || this.fImgs.length &lt;1) {
									this.fBtn.style.display = "none";
									return;
								}
								this.fCurrIdx = 0;
								this.fImgs[0].style.visibility = "";
								this.fPlay = <xsl:value-of select="$pAutoPLay"/>;
								if (this.fPlay){
									animMgr.fAuto = window.setInterval(animMgr.switch,1000);
									this.fBtn.style.display = "none";
								}
							} catch(e){alert("ERROR - animMgr.init: "+e)}
						},
						toggle : function(pBtn){
							try{
								animMgr.fPlay = !animMgr.fPlay;
								pBtn.className = "btn"+(animMgr.fPlay?"Pause":"Play");
								if (animMgr.fPlay){
									animMgr.fAuto = window.setInterval(animMgr.switch,1000);
								} else {
									window.clearInterval(animMgr.fAuto);
								}
								return false;
							} catch(e){alert("ERROR - animMgr.toggle: "+e)}
						},
						switch : function(){
							animMgr.fImgs[animMgr.fCurrIdx++].style.visibility = "hidden";
							if (animMgr.fCurrIdx >= animMgr.fImgs.length) animMgr.fCurrIdx = 0;
							animMgr.fImgs[animMgr.fCurrIdx].style.visibility = "";
						}
					}
				</script>
			</head>
			<body style="width:100%;height:100%;margin:0; overflow:hidden;">
				<div id="animFrame" style="position:absolute;width:100%;height:100%;overflow:hidden;">
					<xsl:apply-templates/>
				</div>
				<a id="animBtn" href="#" class="btnPlay" style="position:absolute;display:block;width:100%;height:100%;" onclick="return animMgr.toggle(this);"><span>Play/Pause</span></a>
				<script type="text/JavaScript">
					animMgr.init();
				</script>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="sp:img"><xsl:if test="@sc:refUri"><div style="position:absolute;width:100%;height:100%;visibility:hidden;"><table style="position:absolute;width:100%;height:100%;text-align:center;border-collapse: collapse;"><tr><td style="padding:0px;"><itemviewimage uri="{@sc:refUri}" style="vertical-align:middle;"/></td></tr></table></div></xsl:if></xsl:template>
	<xsl:template match="text()"/>
</xsl:stylesheet>

