<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core">
    <xsl:param name="pWspPath" />
    
    <!-- ### 
        # Retourne le local-name() du modèle fils (internalisé ou externalisé)
        ### -->
    <xsl:template name="tGetSubModelType">
        <xsl:choose>
            <xsl:when test="@sc:refUri"><!-- item externalisé -->
                <xsl:value-of select="local-name(document(concat($pWspPath,'/',@sc:refUri))/*/*[1])"/>
            </xsl:when>
            <xsl:otherwise><!-- item internalisé -->
                <xsl:value-of select="local-name(*[1])"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="tExtension">
        <xsl:param name="pFilename" />
        
        <!-- Appel récursif du patron tant que l'extension contient un point -->
        <xsl:variable name="vExtension" select="substring-after($pFilename, '.')" />
        <xsl:choose>
            <xsl:when test="contains($vExtension,'.')">
                <xsl:call-template name="tExtension">
                    <xsl:with-param name="pFilename" select="$vExtension" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$vExtension" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="tChangeExtension">
        <xsl:param name="pFilename" />
        <xsl:param name="pNewExtension" select="false()" />
        
        <xsl:variable name="vExtension">
            <xsl:call-template name="tExtension">
                <xsl:with-param name="pFilename" select="$pFilename" />
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$pNewExtension">
                <xsl:value-of select="concat(substring($pFilename, 1, string-length($pFilename) - string-length($vExtension)), $pNewExtension)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring($pFilename, 1, string-length($pFilename) - string-length($vExtension) - 1)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
