<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:of="scpf.org:office" exclude-result-prefixes="sc sp">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no" omit-xml-declaration="yes"/>
	<xsl:param name="vDialog"/>
	<xsl:param name="vAgent"/>
	<xsl:template match="*">
		<div class="searchFra">
			<form id="optSearchForm" method="get" action="http://www.exalead.com/search" target="_blank" onsubmit="optSearchMgr.setQueryVal(this);">
				<input type="hidden" name="q"/>
				<input type="text" class="searchText" name="optSearchText" size="15"/>
				<a class="searchSubmit" href="#" onclick="optSearchMgr.submit(sc$('optSearchForm'));" title="￼Recherche Exalead (nouvelle fenêtre)￼">
					<span>￼Chercher￼</span>
				</a>
			</form>
		</div>
		<script type="text/JavaScript">
	var optSearchMgr = {
		fBaseURL : window.location.href,
		fIsLocal : window.location.hostname == "127.0.0.1" || window.location.hostname == "localhost",
		init: function () {
			this.fBaseURL = this.fBaseURL.substring(this.fBaseURL.indexOf('//')+2,this.fBaseURL.lastIndexOf('/'));
			if (this.fIsLocal) sc$('optSearchForm').optSearchText.disabled = true;
		},
		submit : function(pForm){
			if (this.fIsLocal) return false;
			this.setQueryVal(pForm);
			pForm.submit();
		},
		setQueryVal : function(pForm){
			pForm.q.value=pForm.optSearchText.value+' site:'+this.fBaseURL;
		}
	}
	optSearchMgr.init();
</script>
	</xsl:template>
</xsl:stylesheet>