<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:of="scpf.org:office" exclude-result-prefixes="sc sp">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:param name="vDialog"/>
	<xsl:param name="vAgent"/>
	<xsl:template match="*">
		<div id="disqus_thread"/>
		<script type="text/javascript">
			var disqus_shortname = "<xsl:value-of select="of:optDisqusM/sp:shortName"/>";
			var disqus_identifier = "<xsl:value-of select="resultatDialogue($vDialog, 'act:')"/>";
			(function() {
				var dsq = document.createElement("script"); dsq.type = "text/javascript"; dsq.async = true;
				dsq.src = "http://<xsl:value-of select="of:optDisqusM/sp:shortName"/>.disqus.com/embed.js";
				(document.getElementsByTagName("head")[0] || document.getElementsByTagName("body")[0]).appendChild(dsq);
			})();
		</script>
		<noscript>
			<a href="http://{of:optDisqusM/sp:shortName}.disqus.com/?url=ref">￼;Voir le fil de discussion.￼</a>
		</noscript>
	</xsl:template>
</xsl:stylesheet>