<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:sc="http://www.utc.fr/ics/scenari/v3/core"
	xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" 
	xmlns:of="scpf.org:office" xmlns:xalan="http://xml.apache.org/xalan"
	exclude-result-prefixes="xalan">

	<xsl:import href="utils.xsl"/>
	
	<xsl:output encoding="UTF-8" indent="yes" method="xml"/>
	
	
	
	<!--Rapports-->
	<xsl:template match="sc:item/of:report/sp:pre[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">section</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:pre sc:refUri="{$newFilename}"/>
	</xsl:template>
		
	<xsl:template match="sc:item/of:report/sp:chap[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">section</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:chap sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="sc:item/of:report/sp:post[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">section</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:post sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<!--Diapositives-->
	<xsl:template match="of:slideshow/sp:speakerComment[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">fragment</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:speakerComment sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="of:slideshow/sp:readerComment[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">fragment</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:readerComment sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="sp:slide[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$subModelType='section'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">section</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:slide sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='gallery'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:slide sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='eventList'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:slide sc:refUri="{$newFilename}"/>
			</xsl:when>
		</xsl:choose>
		
	</xsl:template>
	
	<xsl:template match="sp:sec[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$subModelType='section'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">section</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:sec sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='gallery'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:sec sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='eventList'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:sec sc:refUri="{$newFilename}"/>
			</xsl:when>
		</xsl:choose>
		
	</xsl:template>
	
	<!--Changement d'extension dans partie préalable/chapitre/section/annexe-->
	<xsl:template match="sp:evtList[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">object</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:evtList sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="sp:gallery[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">object</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:gallery sc:refUri="{$newFilename}"/>
	</xsl:template>

	<xsl:template match="sp:frag[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">fragment</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:frag sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<!--Site web | Dossier web | Page web-->
	<xsl:template match="sp:co[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">object</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:co sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<xsl:template match="sp:subPage[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$subModelType='section'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">section</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:subPage sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='gallery'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:subPage sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='eventList'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:subPage sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates  select="node() | @*" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	
	<xsl:template match="sp:page[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$subModelType='section'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">section</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:page sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='gallery'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:page sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='eventList'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:page sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates  select="node() | @*" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	
	<xsl:template match="sp:main[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$subModelType='section'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">section</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:main sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='gallery'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:main sc:refUri="{$newFilename}"/>
			</xsl:when>
			<xsl:when test="$subModelType='eventList'">
				<xsl:variable name="newFilename">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">object</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<sp:main sc:refUri="{$newFilename}"/>
			</xsl:when>
		</xsl:choose>
		
	</xsl:template>
	
	<!--Liste d'événements-->
	<xsl:template match="sp:subList[@sc:refUri]">
		<xsl:variable name="newFilename">
			<xsl:call-template name="tChangeExtension">
				<xsl:with-param name="pFilename" select="@sc:refUri"/>
				<xsl:with-param name="pNewExtension">object</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<sp:subList sc:refUri="{$newFilename}"/>
	</xsl:template>
	
	<!-- Text uLink ref -->
	<xsl:template match="sc:uLink[@sc:refUri]">
		<xsl:variable name="subModelType">
			<xsl:call-template name="tGetSubModelType"/>
		</xsl:variable>
		<xsl:variable name="newFilename">
			<xsl:choose>
				<xsl:when test="$subModelType='section' or $subModelType='gallery' or $subModelType='eventList'">
					<xsl:call-template name="tChangeExtension">
						<xsl:with-param name="pFilename" select="@sc:refUri"/>
						<xsl:with-param name="pNewExtension">
							<xsl:choose>
								<xsl:when test="$subModelType='section'">section</xsl:when>
								<xsl:when test="$subModelType='gallery' or $subModelType='eventList'">object</xsl:when>
							</xsl:choose>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="@sc:refUri"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<sc:uLink sc:refUri="{$newFilename}" role="{@role}">
			<xsl:apply-templates/>
		</sc:uLink>
	</xsl:template>
	
	<!--Changement Citation : inlineStyleTag en phraseTag-->
	<xsl:template match="sc:inlineStyle[@role='quote']">
		<sc:phrase>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</sc:phrase>
	</xsl:template>
	
	
	<xsl:template match="node() | @*">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" />
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
