/* Optim Office page manager */
var tplMgr = {
	fCbkInit : true,
	fCbkPath : "des:.cbkClosed",
	fBkBtnPath : "des:.outBkBtn/des:a",
	/* Localisations */
	fStrings : {en:["Return to the main web site"],
	            fr:["Retour au site web principal"],
	            es:["Volver al sitio web principal"]
	            },

	init : function(){
		// Close collapsable blocks that are closed by default.
		if (this.fCbkInit){
			var vCbks = scPaLib.findNodes(this.fCbkPath);
			for (var i in vCbks) {
				var vTgl = scPaLib.findNode("des:a", vCbks[i]);
				if (vTgl) vTgl.onclick();
			}
		}
		if ("scTooltipMgr" in window ) {
			scTooltipMgr.addShowListener(this.sTtShow);
			scTooltipMgr.addHideListener(this.sTtHide);
		}
	},
	saveLocation : function() {
		document.cookie = "lastPageUrl="+escape(document.location.href);
	},
	setBackButtons : function() {
		var vBkBtns = scPaLib.findNodes(this.fBkBtnPath);
		for (var i in vBkBtns) {
			vBkBtns[i].onclick=function(){
				var vArr = /lastPageUrl=([^;]*)/.exec(document.cookie);
				if(vArr && vArr.length==2) this.setAttribute("href", unescape(vArr[1]));
			}
			vBkBtns[i].title = this.xGetStr(0);
		}
	},
	/** Reteive a localized string. */
	xGetStr: function(pStrId) {
		var vLang = navigator.userLanguage || navigator.language;
		vLang = vLang.slice(0,2).toLowerCase();
		if (this.fStrings[vLang])	return this.fStrings[vLang][pStrId];
		else return this.fStrings["en"][pStrId];
	},
	/** Tooltip lib show callback */
	sTtShow: function(pNode) {
		var vClsBtn = scPaLib.findNode("des:a.tt_x", scTooltipMgr.fCurrTt);
		if (vClsBtn) window.setTimeout(function(){vClsBtn.focus();}, pNode.fOpt.DELAY + 10);
	},
	/** Tooltip lib hide callback : this = scTooltipMgr */
	sTtHide: function(pNode) {
		if (pNode) pNode.focus();
	}
}

