<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" xmlns:redirect="com.scenari.xsldom.xalan.lib.Redirect" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" extension-element-prefixes="redirect" exclude-result-prefixes="sc xhtml" version="1.0">
	<xsl:output omit-xml-declaration="yes" indent="no" method="xml"/>
	<xsl:param name="vDialog"/>
	<xsl:param name="vAgent"/>
	<xsl:template match="treeContent">
		<xsl:if test="count(descendant::entry) &gt; 1">
			<hr class="hidden"/>
			<strong class="hidden">￼Navigation :￼</strong>
			<ul>
				<xsl:attribute name="class">
					<xsl:value-of select="concat('outMnu', si(count(entry)=1,' outMnuOneRoot'))"/>
				</xsl:attribute>
				<xsl:apply-templates/>
			</ul>
		</xsl:if>
	</xsl:template>
	<xsl:template match="entry">
		<xsl:variable name="vCLass" select="resultatDialogue(concat(@dialog, '/outlineClasses'))"/>
		<xsl:variable name="vUrl" select="resultatDialogue(string(@dialog), 'act:')"/>
		<xsl:variable name="vType" select="returnFirst(root,'ext')"/>
		<xsl:variable name="vTi" select="si($vType='ext','￼lien externe￼')"/>
		<li class="outMnu_sel_{si(@position = 'current', 'yes', 'no')} outMnu_typ_{$vType} outMnu_{si(entry,'b','l')} {$vCLass}">
			<xsl:variable name="vSubUrl" select="resultatDialogue(string(entry[1]/@dialog), 'act:')"/>
			<xsl:choose>
				<xsl:when test="@position = 'current' or (@position = 'parent' or @position = 'ancestor') and $vSubUrl = $vUrl">
					<span class="outMnu_i" title="{$vTi}">
						<span>
							<xsl:value-of select="@title"/>
						</span>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<a href="{$vUrl}" target="_self" class="outMnu_i outMnu_lnk" title="{$vTi}">
						<span>
							<xsl:value-of select="@title"/>
						</span>
					</a>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="entry">
				<ul class="outMnu_sub">
					<xsl:apply-templates/>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
	<xsl:template match="node()"/>
</xsl:stylesheet>