<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xslt/java" xmlns:of="scpf.org:office" xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" exclude-result-prefixes="java of sfacet sp " extension-element-prefixes="java of sfacet sp " >

<xsl:param name="pItem"/>
<xsl:param name="pIdSubItem"/>
<xsl:param name="pOutlineContext"/>
<xsl:param name="pIncludeTitle"/>

<xsl:template match="/sc:item">
<xsl:choose>
<xsl:when test="$pIdSubItem">
<itemRoot xp="id('{$pIdSubItem}')">
<xsl:if test="$pIncludeTitle"><xsl:apply-templates select="id($pIdSubItem)/*[last()]" mode="titleNode"/></xsl:if>
<xsl:apply-templates select="id($pIdSubItem)/*[last()]" mode="children"/>
</itemRoot>
</xsl:when>
<xsl:otherwise>
<itemRoot xp="sc:item">
<xsl:if test="$pIncludeTitle"><xsl:apply-templates select="of:cv" mode="titleNode"/></xsl:if>
<xsl:apply-templates select="of:cv" mode="children"/>
</itemRoot>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="titleNode" match="of:cv">
<xsl:variable name="vTitle"><title><xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="of:head"><xsl:value-of select="sp:givenName"/><xsl:if test="sp:familyName"><xsl:text> </xsl:text><xsl:value-of select="sp:familyName"/></xsl:if><xsl:if test="sp:tagline"><xsl:text> - </xsl:text><xsl:value-of select="sp:tagline"/></xsl:if></xsl:for-each></title></xsl:variable>
<xsl:variable select="string($vTitle)" name="vTitleInMeta"/>
<titleNode title="{$vTitleInMeta}"/>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="children" match="of:cv">
<children>
<xsl:apply-templates/>
</children>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:status">
<node name="Situation professionnelle actuelle" xp="of:cv/sp:status[{count(preceding-sibling::sp:status) + 1}]">
<xsl:variable name="vTitle"><title><xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="of:blockM"><xsl:value-of select="sp:title"/></xsl:for-each></title></xsl:variable>
<xsl:variable select="string($vTitle)" name="vTitleInMeta"/>
<xsl:choose>
<xsl:when test="$vTitleInMeta and @sc:refUri">
<titleNode title="{$vTitleInMeta}"/>
<sfacet:callOutline includeTitle="false" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:when test="$vTitleInMeta">
<titleNode title="{$vTitleInMeta}"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:diplomas">
<node name="Formation / Diplômes" xp="of:cv/sp:diplomas[{count(preceding-sibling::sp:diplomas) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:experience">
<node name="Expérience professionnelle" xp="of:cv/sp:experience[{count(preceding-sibling::sp:experience) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:skills">
<node name="Compétences" xp="of:cv/sp:skills[{count(preceding-sibling::sp:skills) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:section">
<node name="Autre rubrique" xp="of:cv/sp:section[{count(preceding-sibling::sp:section) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:languages">
<node name="Langues étrangères" xp="of:cv/sp:languages[{count(preceding-sibling::sp:languages) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:leisure">
<node name="Loisirs" xp="of:cv/sp:leisure[{count(preceding-sibling::sp:leisure) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:references">
<node name="Références" xp="of:cv/sp:references[{count(preceding-sibling::sp:references) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="of:cv/sp:interview">
<node name="Entretien virtuel" xp="of:cv/sp:interview[{count(preceding-sibling::sp:interview) + 1}]">
<xsl:choose>
<xsl:when test="@sc:refUri">
<sfacet:callOutline includeTitle="true" refUri="{@sc:refUri}"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates mode="titleNode" select="*[last()]"/>
<xsl:apply-templates mode="children" select="*[last()]"/>
</xsl:otherwise>
</xsl:choose>
</node>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="titleNode" match="of:heading">
<xsl:variable name="vTitle"><title><xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="of:blockM"><xsl:value-of select="sp:title"/></xsl:for-each></title></xsl:variable>
<xsl:variable select="string($vTitle)" name="vTitleInMeta"/>
<titleNode title="{$vTitleInMeta}"/>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="children" match="of:heading">
<children>
<xsl:apply-templates/>
</children>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="titleNode" match="of:interview">
<titleNode title=""/>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="children" match="of:interview">
<children>
<xsl:apply-templates/>
</children>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="titleNode" match="of:interviewPart">
<xsl:variable name="vTitle"><title><xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="of:blockM"><xsl:value-of select="sp:title"/></xsl:for-each></title></xsl:variable>
<xsl:variable select="string($vTitle)" name="vTitleInMeta"/>
<titleNode title="{$vTitleInMeta}"/>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="children" match="of:interviewPart">
<children>
<xsl:apply-templates/>
</children>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="titleNode" match="of:language">
<xsl:variable name="vTitle"><title><xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="of:blockM"><xsl:value-of select="sp:title"/></xsl:for-each></title></xsl:variable>
<xsl:variable select="string($vTitle)" name="vTitleInMeta"/>
<titleNode title="{$vTitleInMeta}"/>
</xsl:template>
<xsl:template xmlns:sfacet="xalan://com.scenari.m.bdp.facet.outline.XslExtFacet" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" mode="children" match="of:language">
<children>
<xsl:apply-templates/>
</children>
</xsl:template>


<xsl:template match="node()|@*"/>
<xsl:template match="node()|@*" mode="titleNode"/>
<xsl:template match="node()|@*" mode="children"/>
</xsl:stylesheet>