<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:lxslt="http://xml.apache.org/xslt" xmlns:redirect="com.scenari.xsldom.xalan.lib.Redirect" xmlns:java="http://xml.apache.org/xslt/java" extension-element-prefixes="redirect java lxslt ">
<xsl:output method="xml" indent="no"/>
<xsl:param name="vDialog"/>
<xsl:param name="vAgent"/>

<xsl:template match="alternative"><xsl:apply-templates/></xsl:template>
<xsl:template match="@lookForAlt"><xsl:attribute name="alt"><xsl:value-of select="si(.='', ancestor::alternative/@alt, .)"/></xsl:attribute></xsl:template>	
	

<xsl:template match="/"><xsl:apply-overlays/><xsl:apply-templates select="node()"/></xsl:template>
<xsl:template match="body">
<xsl:copy>
<xsl:apply-templates select="@*"/>
<xsl:apply-overlays select="." mode="startTags"/>
<xsl:apply-overlays/>
<xsl:apply-templates/>
<xsl:apply-overlays select="." mode="endTags"/>
</xsl:copy>
</xsl:template>
<xsl:template match="zoneContent"><xsl:apply-overlays/><xsl:apply-templates/></xsl:template>
<xsl:template match="ifText"><xsl:if test="descendant::text()[string-length(normalize-space())&gt;0] or descendant::img or descendant::object"><xsl:apply-templates/></xsl:if></xsl:template>
<xsl:template match="hx"><xsl:variable name="vCount" select="count(ancestor::scBlock)"/><xsl:element name="{concat('h', si($vCount &gt; 6, '6', $vCount))}"><xsl:apply-templates select="@*"/><xsl:apply-overlays/><xsl:apply-templates/></xsl:element></xsl:template>
<xsl:template match="addAttribute">
<xsl:variable name="vAttCo"><xsl:choose><xsl:when test="@filter='textOnly'"><xsl:value-of select="normalize-space(.)"/></xsl:when><xsl:otherwise><redirect:serialize omit-xml-declaration="yes"><xsl:value-of select="."/></redirect:serialize></xsl:otherwise></xsl:choose></xsl:variable>
<xsl:choose>
<xsl:when test="@name = 'lookForAlt'">
<xsl:attribute name="alt"><xsl:value-of select="si(string($vAttCo)='', ancestor::alternative/@alt, $vAttCo)" disable-output-escaping="yes"/></xsl:attribute>
</xsl:when>
<xsl:otherwise>
<xsl:attribute name="{@name}"><xsl:value-of select="$vAttCo" disable-output-escaping="yes"/></xsl:attribute>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
	

<xsl:variable name="vBufJs" select="java:java.lang.StringBuffer.new()"/>
<xsl:overlay match="body" mode="endTags" priority="100"><xsl:if test="java:length($vBufJs) &gt; 0"><script type="text/javascript"><xsl:value-of select="java:toString($vBufJs)"/></script></xsl:if></xsl:overlay>

	
<xsl:overlay match="body">
  <xsl:value-of select="execute(java:append($vBufJs, 'scImgMgr.init();'))"/>
</xsl:overlay>

<xsl:template match="scBlock"><div><xsl:apply-templates select="@*"/><xsl:apply-overlays/><xsl:apply-templates/></div></xsl:template>
<xsl:template match="scBlockTitle"/>
	

<xsl:template match="crossRef"/>
<xsl:overlay match="*[crossRef]" priority="1">
<xsl:variable name="vId" select="java:ensureIdOnCurrentResultElt($vDialog, string(crossRef[@prefId]/@prefId))"/>
<xsl:for-each select="crossRef/entry"><xsl:value-of select="java:com.scenari.m.ge.generator.web.CrossRefEntry.addEntry($vDialog, $vId, @keyRef, @value)"/></xsl:for-each>
</xsl:overlay>
	
<xsl:overlay match="a[containWord(@class, 'overLnk')]">
  <xsl:attribute name="onclick">scImgMgr.loading(); return false;</xsl:attribute>
  <xsl:attribute name="title">Cliquez pour agrandir (nouvelle fenêtre)</xsl:attribute>
</xsl:overlay>

	<xsl:template match="* | processing-instruction() | comment()"><xsl:copy><xsl:apply-templates select="@*"/><xsl:apply-overlays/><xsl:apply-templates/></xsl:copy></xsl:template>
	<xsl:template match="@* | text()"><xsl:copy/></xsl:template>
</xsl:stylesheet>
