<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:presentation="urn:oasis:names:tc:opendocument:xmlns:presentation:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:sp="http://www.utc.fr/ics/scenari/v3/primitive" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:xalan="http://xml.apache.org/xalan" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:sl="http://www.utc.fr/ics/scenari/v3/library" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0" xmlns:sc="http://www.utc.fr/ics/scenari/v3/core" xmlns:dc="http://purl.org/dc/elements/1.1/" exclude-result-prefixes="presentation table ooo sp script form xsd chart xalan math draw meta dom office dr3d style xforms svg ooow number sl xsi oooc fo xlink text scodPp sc dc " >
<xsl:output xmlns:xsl="http://www.w3.org/1999/XSL/Transform" omit-xml-declaration="no" indent="no" method="xml"/><xsl:param xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="vAgent"/><xsl:param xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="vDialog"/><xsl:key xmlns:xsl="http://www.w3.org/1999/XSL/Transform" use="@category" match="//scodPp:dataBlockDeclaration" name="dataBlockDeclaration"/><xsl:key xmlns:xsl="http://www.w3.org/1999/XSL/Transform" use="@id" match="//scodPp:forEachBlock" name="forEachBlock"/><xsl:key xmlns:xsl="http://www.w3.org/1999/XSL/Transform" use="@id" match="//scodPp:dataBlock" name="dataBlock"/><xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//scodPp:showDataBlocks" name="scodPpShowDataBlocks"/><xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//scodPp:dataBlock" name="scodPpDataBlocks"/><xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="$scodPpDataBlocks[scodPp:overrideContentDeclaration//scodPp:block.data]" name="scodPpDataBlocksWithContent"/><xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="/" name="vDocRoot"/><xsl:template xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="/scodPp:root"><scodPp:root xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"><xsl:apply-templates/></scodPp:root></xsl:template><xsl:template match="scodPp:addSection"><xsl:variable select="si(@condition, xalan:evaluate(@condition), false)" name="vCondition"/><xsl:choose><xsl:when test="not($vCondition)"><xsl:apply-templates select="node()|text()"/></xsl:when><xsl:otherwise><text:p xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_noDisplayNoKeep"> </text:p><text:section xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:name="resSection{generate-id()}" text:style-name="_scod_section"><xsl:apply-templates select="node()|text()"/></text:section><text:p xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_noDisplayNoKeep"> </text:p></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:ifNotNull"><xsl:choose><xsl:when test="not(ancestor::scodPp:notIfNotNull)"><xsl:variable name="vContent"><xsl:apply-templates/></xsl:variable><xsl:if test="string-length(normalize-space($vContent))&gt;0 or boolean(./*/*)"><xsl:copy-of select="$vContent"/></xsl:if></xsl:when><xsl:otherwise><xsl:apply-templates/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:notIfNotNull"><xsl:apply-templates/></xsl:template><xsl:template match="scodPp:listItem"><xsl:choose><xsl:when test="local-name(..)='list'"><text:list-item xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0"><xsl:if test="count(preceding-sibling::scodPp:listItem)=0"><xsl:attribute name="text:start-value">1</xsl:attribute></xsl:if><xsl:apply-templates/></text:list-item></xsl:when><xsl:otherwise><text:list xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0"><text:list-item><xsl:apply-templates/></text:list-item></text:list></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="office:automatic-styles"><xsl:copy><xsl:apply-templates select="@*|node()|text()"/><xsl:comment>### Styles dynamiques</xsl:comment><xsl:apply-templates mode="content.automatic-styles" select="//scodPp:flow[@file='content' and @area='automatic-styles']"/></xsl:copy></xsl:template><xsl:template match="scodPp:flow"/><xsl:template mode="content.automatic-styles" match="scodPp:flow[@file='content' and @area='automatic-styles']"><xsl:apply-templates/></xsl:template><xsl:template name="getDataBlockList"><xsl:param name="pCateg"/><xsl:param name="pIdForEach"/><xsl:for-each select="key('dataBlockDeclaration', $pCateg)"><blocks category="{$pCateg}"><documentBlockList firstShowDbId="{$scodPpShowDataBlocks[@category=$pCateg][.//scodPp:block.data][1]//scodPp:forEachBlock[1]/@id}"><xsl:apply-templates mode="getDataBlockList" select="$scodPpDataBlocks[@category=$pCateg]"/></documentBlockList><xsl:choose><xsl:when test="key('dataBlockDeclaration', @category)/@sort!='none'"><xsl:apply-templates mode="getBlockDef" select="$scodPpDataBlocks[@category=$pCateg]"><xsl:with-param select="$pIdForEach" name="pIdForEach"/><xsl:sort order="{key('dataBlockDeclaration', @category)/@sort}" data-type="text" select="normalize-space(scodPp:sortKey/@value)"/></xsl:apply-templates></xsl:when><xsl:otherwise><xsl:apply-templates mode="getBlockDef" select="$scodPpDataBlocks[@category=$pCateg]"><xsl:with-param select="$pIdForEach" name="pIdForEach"/></xsl:apply-templates></xsl:otherwise></xsl:choose></blocks></xsl:for-each></xsl:template><xsl:template mode="getDataBlockList" match="scodPp:dataBlock"><xsl:variable select="scodPp:id/@value" name="vId"/><xsl:variable select="@category" name="vCategory"/><xsl:variable name="vIsContentShowInDocument"><xsl:choose><xsl:when test="key('dataBlockDeclaration', @category)/scodPp:content//scodPp:block.data or key('dataBlockDeclaration', @category)/scodPp:conditionalContent//scodPp:block.data">true</xsl:when><xsl:when test="scodPp:overrideContentDeclaration and scodPp:overrideContentDeclaration//scodPp:block.data">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:variable><dataBlock isContentShowInDocument="{normalize-space($vIsContentShowInDocument)}" blockId="{scodPp:id/@value}" category="{@category}" refId="{@id}"/></xsl:template><xsl:template mode="getBlockDef" match="scodPp:dataBlock"><xsl:param name="pIdForEach"/><xsl:variable select="scodPp:id/@value" name="vId"/><xsl:variable select="@category" name="vCategory"/><xsl:variable name="vIdBlockList"><xsl:choose><xsl:when test="key('dataBlockDeclaration', @category)/@hideSameBlock='yes'"><xsl:for-each select="$scodPpDataBlocks[@category=$vCategory and scodPp:id/@value=$vId]"><xsl:value-of select="@id"/>###</xsl:for-each></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="vData"><xsl:copy-of select="scodPp:data/* | scodPp:data/text()"/></xsl:variable><xsl:variable select="string-length(normalize-space($vData))&gt;0 or boolean(scodPp:data/*)" name="vHasData"/><xsl:variable name="vIsContentShowInDocument"><xsl:choose><xsl:when test="key('dataBlockDeclaration', @category)/scodPp:content//scodPp:block.data or key('dataBlockDeclaration', @category)/scodPp:conditionalContent//scodPp:block.data">true</xsl:when><xsl:when test="boolean($scodPpDataBlocksWithContent[scodPp:id/@value=$vId and @category=$vCategory])">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:variable><xsl:variable select="si($scodPpShowDataBlocks[@category=$vCategory]//scodPp:block.data, 'true', 'false')" name="vIsContentShowInDataBlockList"/><xsl:variable select="si(key('dataBlockDeclaration', @category)/@hideBlockIfShowInContent='yes', 'true', 'false')" name="vIgnoreAlreadyShowBlocks"/><xsl:variable name="vBlockType"><xsl:choose><xsl:when test="$vIgnoreAlreadyShowBlocks!='true' or normalize-space($vIsContentShowInDocument)='false'"><xsl:choose><xsl:when test="not(key('dataBlockDeclaration', @category)/@hideEmptyBlocks='yes' and not($vHasData))             and not(key('dataBlockDeclaration', @category)/@hideSameBlock='yes' and string-length(scodPp:id/@value)!=0 and preceding::scodPp:dataBlock[@category=$vCategory and scodPp:id/@value=$vId])">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:variable><block isContentShowInDataBlockList="{normalize-space($vIsContentShowInDataBlockList)}" isContentShowInDocument="{normalize-space($vIsContentShowInDocument)}" idBlock="{scodPp:id/@value}" sortKey="{normalize-space(scodPp:sortKey/@value)}" category="{@category}" idList="{normalize-space($vIdBlockList)}" display="{normalize-space($vBlockType)}"><title><xsl:copy-of select="scodPp:title/* | scodPp:title/text()"/></title><data refBlockId="{@id}"/><declaration><xsl:copy-of select="key('dataBlockDeclaration', @category)/* | key('dataBlockDeclaration', @category)/text()"/></declaration><xsl:if test="string-length(normalize-space($pIdForEach))&gt;0"><definition><xsl:copy-of select="key('forEachBlock', $pIdForEach)/*"/></definition></xsl:if></block></xsl:template><xsl:template match="scodPp:dataBlock"><xsl:variable select="@id" name="vId"/><xsl:variable select="scodPp:id/@value" name="vBlockId"/><xsl:variable select="@category" name="vBlockCategory"/><xsl:variable select="xalan:evaluate(concat('$vDbDom_', @category))" name="vBlockList"/><xsl:choose><xsl:when test="name(ancestor::*[name()='text:p' or name()='draw:text-box'][1])='text:p'"><text:span xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_hiddenText"><text:bookmark-start text:name="{$vId}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:span></xsl:when><xsl:otherwise><text:p xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_hiddenParagraph"><text:bookmark-start text:name="{$vId}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:p></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="scodPp:overrideContentDeclaration"><xsl:apply-templates select="scodPp:overrideContentDeclaration/* | scodPp:overrideContentDeclaration/text()"/></xsl:when><xsl:when test="$vBlockList//block[contains(@idList, $vId)]/declaration/scodPp:content"><xsl:apply-templates select="$vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:content/* | $vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:content/text()"/></xsl:when><xsl:when test="$vBlockList//block[contains(@idList, $vId)]/declaration/scodPp:conditionalContent/@type='position'"><xsl:variable name="vIsFirstCall"><xsl:for-each select="$vBlockList/blocks/documentBlockList/dataBlock[@refId=$vId and @category=$vBlockCategory]"><xsl:value-of select="si(boolean(preceding-sibling::dataBlock[@blockId=$vBlockId and @category=$vBlockCategory]), 'false', 'true')"/></xsl:for-each></xsl:variable><xsl:choose><xsl:when test="$vIsFirstCall='true'"><xsl:apply-templates select="$vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:firstCall/* | $vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:firstCall/text()"/></xsl:when><xsl:otherwise><xsl:apply-templates select="$vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:otherCalls/* | $vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:otherCalls/text()"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$vBlockList//block[contains(@idList, $vId)]/declaration/scodPp:conditionalContent/@type='data'"><xsl:choose><xsl:when test="$vBlockList//block[@display='true'][contains(@idList, $vId)][1]/@isContentShowInDocument='true' or $vBlockList//block[@display='true'][contains(@idList, $vId)][1]/@isContentShowInDataBlockList='true'"><xsl:apply-templates select="$vBlockList//block[@display='true'][contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:ifDataIsShow/* | $vBlockList//block[@display='true'][contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:ifDataIsShow/text()"/></xsl:when><xsl:otherwise><xsl:apply-templates select="$vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:ifDataIsNotShow/* | $vBlockList//block[contains(@idList, $vId)][1]/declaration/scodPp:conditionalContent/scodPp:ifDataIsNotShow/text()"/></xsl:otherwise></xsl:choose></xsl:when></xsl:choose><xsl:choose><xsl:when test="name(ancestor::*[name()='text:p' or name()='draw:text-box'][1])='text:p'"><text:span xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_hiddenText"><text:bookmark-end text:name="{$vId}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:span></xsl:when><xsl:otherwise><text:p xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_hiddenParagraph"><text:bookmark-end text:name="{$vId}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:p></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:showDataBlocks"><xsl:choose><xsl:when test="@hideIfNoBlocks='yes'"><scodPp:condition xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0" xpath="boolean(.//scodPp:temp[@key='displayedBlock'])"><xsl:apply-templates/></scodPp:condition></xsl:when><xsl:otherwise><xsl:apply-templates/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:forEachBlock"><xsl:variable select="ancestor-or-self::scodPp:showDataBlocks/@category" name="vCateg"/><xsl:variable name="vBlockList"><root showDataBlockId="{@id}"><xsl:call-template name="getDataBlockList"><xsl:with-param select="$vCateg" name="pCateg"/><xsl:with-param select="@id" name="pIdForEach"/></xsl:call-template></root></xsl:variable><xsl:apply-templates mode="definition" select="xalan:nodeset($vBlockList)/root/*"/></xsl:template><xsl:template mode="definition" match="blocks"><xsl:apply-templates mode="definition"/></xsl:template><xsl:template mode="definition" match="block[@display='true']"><scodPp:temp xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0" value="true" key="displayedBlock"/><xsl:apply-templates select="definition/* | definition/text()"/></xsl:template><xsl:template match="block[@display='false']"/><xsl:template match="scodPp:refBlock | scodPp:ifRefBlock"><xsl:variable select="ancestor::*[name()='block' or name()='scodPp:dataBlock'][1]" name="vBlock"/><xsl:variable select="$vBlock/@category" name="vCategory"/><xsl:variable select="si(local-name($vBlock)='block', normalize-space($vBlock/@idBlock), $vBlock/scodPp:id/@value)" name="vIdBlock"/><xsl:variable select="si(local-name($vBlock)='block',               ancestor::blocks/documentBlockList,               xalan:evaluate(concat('$vDbDom_', $vCategory))/blocks/documentBlockList)" name="vDataBlockList"/><xsl:variable select="$vDataBlockList/dataBlock[@category=$vCategory and @blockId=$vIdBlock][1]/@refId" name="vFirstCall"/><xsl:variable select="$vDataBlockList/dataBlock[@category=$vCategory and @blockId=$vIdBlock and @isContentShowInDocument='true'][1]/@refId" name="vFirstCallData"/><xsl:variable select="concat($vDataBlockList/@firstShowDbId,$vIdBlock)" name="vFirstShowDbCall"/><xsl:variable name="vRefBlockId"><xsl:choose><xsl:when test="@position='first'"><xsl:value-of select="$vFirstCall"/></xsl:when><xsl:when test="@position='firstCallData' and $vFirstCallData"><xsl:value-of select="$vFirstCallData"/></xsl:when><xsl:when test="@position='firstCallData' and $vFirstShowDbCall"><xsl:value-of select="$vFirstShowDbCall"/></xsl:when><xsl:when test="@position='firstCallData'"><xsl:value-of select="$vFirstCall"/></xsl:when></xsl:choose></xsl:variable><xsl:choose><xsl:when test="name()='scodPp:ifRefBlock'"><scodPp:ifBookmark xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0" id="{$vRefBlockId}"><xsl:apply-templates/></scodPp:ifBookmark></xsl:when><xsl:when test="@format='xlink'"><text:a xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xlink:href="#{$vRefBlockId}" xlink:type="simple"><xsl:apply-templates/></text:a></xsl:when><xsl:otherwise><text:bookmark-ref xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:ref-name="{$vRefBlockId}" text:reference-format="{@format}"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:block.data"><xsl:variable select="ancestor::*[name()='block' or name()='scodPp:dataBlock'][1]" name="vBlock"/><xsl:choose><xsl:when test="local-name($vBlock)='block'"><xsl:variable select="ancestor::root/@showDataBlockId" name="vShowDbId"/><xsl:variable select="$vBlock/data/@refBlockId" name="vBlockId"/><text:p xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" text:style-name="_scod_noDisplay"><text:bookmark-start text:name="{concat($vShowDbId, $vBlock/@idBlock)}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:p><xsl:for-each select="$vDocRoot"><xsl:apply-templates select="key('dataBlock', $vBlockId)[1]/scodPp:data/* | key('dataBlock', $vBlockId)[1]/scodPp:data/text()"/></xsl:for-each><text:p text:style-name="_scod_noDisplay"><text:bookmark-end text:name="{concat($vShowDbId, $vBlock/@idBlock)}"/><scodPp:notIfNotNull xmlns:scodPp="scenari.eu:openDocumentExtension.postprocessing:1.0"/></text:p></xsl:when><xsl:otherwise><xsl:apply-templates select="$vBlock/scodPp:data/* | $vBlock/scodPp:data/text()"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:block.label"><xsl:variable select="ancestor::*[name()='block' or name()='scodPp:dataBlock'][1]" name="vBlock"/><xsl:choose><xsl:when test="local-name($vBlock)='block'"><xsl:value-of select="$vBlock/title"/></xsl:when><xsl:otherwise><xsl:value-of select="$vBlock/scodPp:title"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="scodPp:block.position"><xsl:variable select="@format" name="vFormat"/><xsl:for-each select="ancestor::block[1]"><xsl:number format="{$vFormat}" value="count(preceding-sibling::block[@display='true'])+1"/></xsl:for-each></xsl:template><xsl:template match="scodPp:callBlockPages"><xsl:copy><xsl:attribute name="separator"><xsl:value-of select="@separator"/></xsl:attribute><xsl:attribute name="refIdList"><xsl:value-of select="ancestor::block/@idList"/></xsl:attribute><xsl:apply-templates/></xsl:copy></xsl:template><xsl:template match="scodPp:idBlock"><xsl:apply-templates/></xsl:template><xsl:template match="scodPp:idbId"><xsl:value-of select="generate-id(ancestor-or-self::*[name()='scodPp:idBlock'][1])"/></xsl:template><xsl:template match="@*[.='[scodPp[idbId]scodPp]']"><xsl:copy><xsl:value-of select="generate-id(ancestor-or-self::*[name()='scodPp:idBlock'][1])"/></xsl:copy></xsl:template><xsl:template match="scodPp:idbPosition"><xsl:variable select="ancestor::scodPp:idBlock[1]/@categ" name="vCategBlock"/><xsl:value-of select="count(preceding::scodPp:idBlock[@categ=$vCategBlock])"/></xsl:template><xsl:template match="@*[.='[scodPp[idbPosition]scodPp]']"><xsl:variable select="ancestor::scodPp:idBlock[1]/@categ" name="vCategBlock"/><xsl:copy><xsl:value-of select="count(preceding::scodPp:idBlock[@categ=$vCategBlock])"/></xsl:copy></xsl:template><xsl:template match="@*[starts-with(., '[scodPp[xpath:')]"><xsl:variable select="substring-before(substring-after(., 'xpath:'), ']scodPp]')" name="vXpath"/><xsl:if test="string-length(normalize-space($vXpath))&gt;0"><xsl:variable select="xalan:evaluate($vXpath)" name="valueXpath"/><xsl:attribute name="{name()}"><xsl:value-of select="$valueXpath"/></xsl:attribute></xsl:if></xsl:template><xsl:template match="scodPp:error"/><xsl:template match="scodPp:ifSequence | scodPp:section"><xsl:copy><xsl:apply-templates select="@*|node()|text()"/></xsl:copy></xsl:template><xsl:template match="@*|node()|text()"><xsl:copy><xsl:apply-templates select="@*|node()|text()"/></xsl:copy></xsl:template><xsl:template match="scodPp:resources"/><xsl:template match="scodPp:dataBlockDeclaration"/></xsl:stylesheet>