/*
 * LICENCE[[
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1/CeCILL 2.O 
 *
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License 
 * for the specific language governing rights and limitations under the 
 * License. 
 * 
 * The Original Code is kelis.fr code. 
 * 
 * The Initial Developer of the Original Code is 
 * sylvain.spinelli@kelis.fr 
 * 
 * Portions created by the Initial Developer are Copyright (C) 2009
 * the Initial Developer. All Rights Reserved. 
 * 
 * Contributor(s): 
 * 
 * 
 * Alternatively, the contents of this file may be used under the terms of 
 * either of the GNU General Public License Version 2 or later (the "GPL"), 
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"), 
 * or the CeCILL Licence Version 2.0 (http://www.cecill.info/licences.en.html), 
 * in which case the provisions of the GPL, the LGPL or the CeCILL are applicable 
 * instead of those above. If you wish to allow use of your version of this file 
 * only under the terms of either the GPL or the LGPL, and not to allow others 
 * to use your version of this file under the terms of the MPL, indicate your 
 * decision by deleting the provisions above and replace them with the notice 
 * and other provisions required by the GPL or the LGPL. If you do not delete 
 * the provisions above, a recipient may use your version of this file under 
 * the terms of any one of the MPL, the GPL, the LGPL or the CeCILL.
 * ]]LICENCE
 */

const Cc = Components.classes;
const Ci = Components.interfaces;

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");


//Méthodes communes à scWspTypeUi et scWspOptionUi.
var scWspUi = {
	
	/**
	 * Retourne la définiton Xml de ce WspUi.
	 * Attention : ce DOM ne doit pas être modifié.
	 */
	getWspUiDefinition : function() {
		return this.fUiDom;
	},
	
	/** Retourne l'uri du wspUi. */
	getUri : function(){
		return this.fUiDom.getAttribute("uri");
	},
	
	/** Retourne la key du wspUi, ie l'uri sans la langue. */
	getKey : function(){
		return this.fUiDom.getAttribute("key") || this.getUri();
	},
	
	/** Retourne la langue du wspUi. Retourne "" si c'est la langue par défaut (ie langue non spécifiée). */
	getLang : function(){
		return this.fUiDom.getAttribute("lang") || "";
	},
	
	/** Retourne la version du wspUi */
	getVersion : function(){
		return this.fUiDom.getAttribute("version");
	},
	
	/** Retourne le code du chrome dans lequel ce WspUi est déclaré. */
	getChromeCode : function(){
		//On peut aussi aller rechercher l'attribut code sur la balise racine pack...
		return /chrome:\/\/([^\/]*)\/.*/.exec(this.fUiDom.ownerDocument.documentURI)[1];
	},
	
	/** Retourne le titre. **/
	getTitle : function() {
		return this.fUiDom.getAttribute("title") || this.fUiDom.getAttribute("uri");
	},
	
	/** Retourne l'URL d'une page XUL correspondant à une présentation de l'atelier. **/
	getWspPresUrl : function() {
		return this.fUiDom.getAttribute("wspPresUrl");
	}
};

function scWspTypeUi(){
}

scWspTypeUi.prototype = {
	
	getWspUiDefinition : scWspUi.getWspUiDefinition,
	getUri : scWspUi.getUri,
	getKey : scWspUi.getKey,
	getLang : scWspUi.getLang,
	getChromeCode : scWspUi.getChromeCode,
	getVersion : scWspUi.getVersion,
	getTitle : scWspUi.getTitle,
	getWspPresUrl : scWspUi.getWspPresUrl,
	
	/** Initialisation. **/
	init : function(pUiDom) {
		this.fUiDom = pUiDom;
	},
	
	/** Ce n'est pas une optionUi. **/
	isOptionUi : function(){
		return false;
	},
	
	/** Retourne l'URL de l'icon du WSP. **/
	getWspIconUrl : function() {
		return this.fUiDom.getAttribute("wspIconUrl");
	},
	
	/** Retourne l'URL du rep contenant les icons des espaces. **/
	getSpaceFolderIconUrl : function() {
		return this.fUiDom.getAttribute("spaceFolderIconUrl");
	},
	
	/** Retourne l'URL du rep contenant les icons des espaces. **/
	getSpaceFolderOpenIconUrl : function() {
		return this.fUiDom.getAttribute("spaceFolderOpenIconUrl");
	},
 
	/** Retourne l'URL du rep contenant les icons d'un item de type NULL. **/
	getItemNullFolderIconUrl : function() {
		return this.fUiDom.getAttribute("itemNullFolderIconUrl");
	},
	
	classDescription : "WspTypeUi",
	classID : Components.ID("{56A6270C-0B0F-4845-91A2-83A73D508101}"),
	contractID : "@scenari.com/ui/wspType;1",
	QueryInterface : XPCOMUtils.generateQI([Ci.scIWspUi, Ci.scIWspTypeUi])
};



function scWspOptionUi() {
}

scWspOptionUi.prototype = {
	
	getWspUiDefinition : scWspUi.getWspUiDefinition,
	getUri : scWspUi.getUri,
	getKey : scWspUi.getKey,
	getLang : scWspUi.getLang,
	getChromeCode : scWspUi.getChromeCode,
	getVersion : scWspUi.getVersion,
	getTitle : scWspUi.getTitle,
	getWspPresUrl : scWspUi.getWspPresUrl,
	
	/** Initialisation.**/
	init : function(pUiDom) {
		try{
			this.fUiDom = pUiDom;
			this.fOverlays = {};
			this.xParseOverlayList();
		}catch(e){
			debug("scWspOptionUi > init :: " + e);
		}
	},
	
	/** C'est une optionUi. */
	isOptionUi : function(){
		return true;
	},
	
	/** Retourne la key du wspUi parent. */
	getParentKey : function(){
		//<wspType lang="pa" key="Office-0_9"/>
		var vParentNode = this.fUiDom.getElementsByTagName("wspType")[0];
		return vParentNode ? vParentNode.getAttribute("key") : null;
	},

	/** Retourne la langue recherchée pour le wspUi parent. */
	getParentLang : function(){
		//<wspType lang="pa" key="Office-0_9"/>
		var vParentNode = this.fUiDom.getElementsByTagName("wspType")[0];
		return vParentNode ? vParentNode.getAttribute("lang") || "" : "";
	},
	
	/** Retourne le wspUi parent. */
	getParent : function(){
		if( ! ("fParent" in this)) {
			this.fParent = null;
			var vParentKey = this.getParentKey();
			if(vParentKey) {
				var vPackRegSvc = Cc["@scenari.com/packregistryservice;1"].getService(Ci.scIPackRegistryService);
				this.fParent = vPackRegSvc.findWspUi(vParentKey, this.getParentLang());
			}
		}
		return this.fParent;
	},
	
	/** Retourne la nature du wspOptionUi. Retourne "" si non spécififié. */
	getNature : function(){
		return this.fUiDom.getAttribute("nature");
	},
		
	/** Retourne la liste des overlays déclarés pour le pPack et pModel. **/
	getMainviewOverlayList : function(pPack, pModel) {
		try{
			if(pPack && pModel){
				var vId = this.xGetOvId(pPack, pModel);
				return this.fOverlays[vId];
			}
			return null;
		}catch(e){
			debug("getMainviewOverlayList :: " + e);
			return null;
		}
	},
	
	xParseOverlayList : function() {
		try{
			var vOverlayList = this.fUiDom.getElementsByTagName("mainViewOverlay");
			for(var ii=0; ii < vOverlayList.length; ii++){
				var vId = this.xGetOvId(vOverlayList[ii].getAttribute("pack"), vOverlayList[ii].getAttribute("model"));
				
				vOvUrl = Cc["@mozilla.org/supports-cstring;1"].createInstance(Ci.nsISupportsCString);
				vOvUrl.data = vOverlayList[ii].getAttribute("overlay"); 
				
				if(!this.fOverlays[vId]) this.fOverlays[vId] = Cc["@mozilla.org/array;1"].createInstance(Ci.nsIMutableArray);
				this.fOverlays[vId].appendElement(vOvUrl, false);
			}
		}catch(e){
			debug("xParseOverlayList :: " + e);
		}
	},
	
	xGetOvId : function(pPack, pModel) {
		return pPack + "*" + pModel;
	},
	
	classDescription : "WspOptionUi",
	classID : Components.ID("{56A6270C-0B0F-4845-91A2-83A73D508102}"),
	contractID : "@scenari.com/ui/wspOption;1",
	QueryInterface : XPCOMUtils.generateQI([Ci.scIWspUi, Ci.scIWspOptionUi])
};
	
function debug(pText){
	var vConsoleService = Cc["@mozilla.org/consoleservice;1"].getService(Ci.nsIConsoleService);
	vConsoleService.logStringMessage("scWspUi > " + pText);
}

function NSGetModule(compMgr, fileSpec)
  XPCOMUtils.generateModule([scWspTypeUi, scWspOptionUi]);