/*
 * LICENCE[[
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1/CeCILL 2.O 
 *
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License 
 * for the specific language governing rights and limitations under the 
 * License. 
 * 
 * The Original Code is utc.fr code. 
 * 
 * The Initial Developer of the Original Code is 
 * Universite de Technologie de Compiegne. 
 * 
 * Portions created by the Initial Developer are Copyright (C) 2005 
 * the Initial Developer. All Rights Reserved. 
 * 
 * Contributor(s): 
 * 
 * 
 * Alternatively, the contents of this file may be used under the terms of 
 * either of the GNU General Public License Version 2 or later (the "GPL"), 
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"), 
 * or the CeCILL Licence Version 2.0 (http://www.cecill.info/licences.en.html), 
 * in which case the provisions of the GPL, the LGPL or the CeCILL are applicable 
 * instead of those above. If you wish to allow use of your version of this file 
 * only under the terms of either the GPL or the LGPL, and not to allow others 
 * to use your version of this file under the terms of the MPL, indicate your 
 * decision by deleting the provisions above and replace them with the notice 
 * and other provisions required by the GPL or the LGPL. If you do not delete 
 * the provisions above, a recipient may use your version of this file under 
 * the terms of any one of the MPL, the GPL, the LGPL or the CeCILL.
 * ]]LICENCE
 */
const WSREGISTRYSERVICE_CONTRACTID = '@scenari.com/wspregistryservice;1';
const WSREGISTRYSERVICE_CID = Components.ID('{7E2B58E8-E168-403E-AD45-1F7CA1255742}');
const WSREGISTRYSERVICE_IID = Components.interfaces.scIWspRegistryService;

const WSP_IID = Components.interfaces.scIWsp;
const WSPOPTIONUI_IID = Components.interfaces.scIWspOptionUi;
const WSPTYPEUI_IID = Components.interfaces.scIWspTypeUi;
const WSPSERVER_IID = Components.interfaces.scIWspServer;

var nsLoginManager = Components.classes["@mozilla.org/login-manager;1"].getService(Components.interfaces.nsILoginManager);
var nsLoginInfo = new Components.Constructor("@mozilla.org/login-manager/loginInfo;1", Components.interfaces.nsILoginInfo, "init");

// ###
// # Définition du scWspRegistryService
// #
function scWspRegistryService() {
	this.fFilePath = null;
	this.fFile = null;
	this.fListeners = [];
	this.fListServer = new Object();
	try{
		//initialisation du fichier de config
		var vFolderService = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
		this.fFile = vFolderService.get("ProfD", Components.interfaces.nsIFile);
		//détermination de l'espace de travail dans le profil dédié à cette application (utilisé en mode XPI)
		var vWorkZone = "";
		try{vWorkZone = gPrefs.getCharPref("scenari.profileWorkDirectory");}catch(e){};
		if(vWorkZone!=""){
			this.fFile.append("extensions");// permet la supp de ce fichier lorts de la désinstallation de l'extension
			this.fFile.append(vWorkZone);
		}
		this.fFile.append("scListeWsp.xml");
		if (!this.fFile.exists()) this.fFile.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0644);

		//chargement du fichier
		var vListConfig = null;
		var vIS = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
		vIS.init(this.fFile,0x01, 00004, null);
		var vSIS = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
		vSIS.init(vIS);
		try{
			var vDomParser = Components.classes["@mozilla.org/xmlextras/domparser;1"].createInstance(Components.interfaces.nsIDOMParser);
			vListConfig = vDomParser.parseFromString(vSIS.read(vSIS.available()), "text/xml");
			if(vListConfig.documentElement.nodeName == "parsererror") {
				debug("Echec au parsing du fichier de configuration.");
				this.xSaveConfig();
				vListConfig = this.xGetCurrentDomConfig();
			}
		}catch(e){
			debug("Echec à la lecture du fichier de configuration : "+e);
			this.xSaveConfig();
			vListConfig = this.xGetCurrentDomConfig();
		}

		// construction de la liste des server
		if(vListConfig){
			// si le fichier de config n'est pas null
			var vDefaultUrlLocal = gPrefs.getCharPref("scenari.urlServerLocal");
			var vListServerRead = vListConfig.documentElement.getElementsByTagName('server');
			for(var i=0; i < vListServerRead.length; i++){
				var vServerNode = vListServerRead[i];
				var vUrl = "";
				if(vServerNode.hasAttribute("type") && vServerNode.getAttribute("type")=="local"){
					vUrl = vDefaultUrlLocal;
				}else{
					vUrl = vServerNode.getAttribute("url");
				}
				var vLogin = (vServerNode.hasAttribute("login")) ? vServerNode.getAttribute("login") : null;
				var vServer = this.searchServer(vUrl, vLogin);
				if(!vServer) vServer = new scWspServer(vUrl, vServerNode.getAttribute("title"), vLogin);
				if(vServerNode.hasAttribute("savePassword")) vServer.setSavePsswdFlag(vServerNode.getAttribute("savePassword")=="true");
				this.fListServer[vServer.getId()] = vServer;
				// construction de la liste des wsp de ce server
				var vListWspRead = vServerNode.getElementsByTagName('wsp');
				for(var ii=0; ii < vListWspRead.length; ii++){
					var vWspNode = vListWspRead[ii];
					vServer.addWsp(
						vWspNode.getAttribute("code"),
						vWspNode.getAttribute("comment"),
						vWspNode.getAttribute("actif")=="true"
					);
				}				
			}
		}
	}catch(e){
		debug("sWspRegistryService:xLoadWsp : "+e);
	}	
}


scWspRegistryService.prototype = {
	
	/**
	 * 
	 * 
	 */
	getWsp: function (pIdServer, pCode){
		var vServer = this.fListServer[pIdServer];
		if(vServer) {
			return vServer.getWsp(pCode);
		}
		return null;
	},
		
	/**
	 * Retourne tous les ateliers actifs.
	 * 
	 */
	getEnabledWsps: function (){
		try{
			var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
			for(var vIdServer in this.fListServer){
				var vServer = this.fListServer[vIdServer];
				for(var vCdWsp in vServer.fWsps){
					var vWsp = vServer.fWsps[vCdWsp];
					if(vWsp.isActive()) {
						vArr.AppendElement(vWsp.QueryInterface(Components.interfaces.nsISupports));
					}
				}
			}
			return vArr;
		}catch(e){
			debug("sWspRegistryService > getEnabledWsps : " + e);
			return null;
		}
	},
	
	/**
	 * Retourne tous les ateliers inactifs.
	 * 
	 */
	getDisabledWsps : function (){
		try{
			var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
			for(var vIdServer in this.fListServer){
				var vServer = this.fListServer[vIdServer];
				for(var vCdWsp in vServer.fWsps){
					var vWsp = vServer.fWsps[vCdWsp];
					if(!vWsp.isActive()) {
						vArr.AppendElement(vWsp.QueryInterface(Components.interfaces.nsISupports));
					}
				}
			}
			return vArr;
		}catch(e){
			debug("sWspRegistryService > getDisabledWsps : " + e);
			return null;
		}
	},
	
	/**
	 * Retourne tous les serveurs déclarés
	 * @return collection de scIWspServer
	 */
	getServers: function (){
		try{
			var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
			var vArray = [];
			for(var vCdServer in this.fListServer) vArray.push(vCdServer);
			vArray.sort(function(p1, p2){return p1.localeCompare(p2);});
			for(var i = 0; i < vArray.length; i++){
				vArr.AppendElement(this.fListServer[vArray[i]].QueryInterface(Components.interfaces.nsISupports));
			}
			return vArr;
		}catch(e){
			debug("sWspRegistryService > getServers: " + e);
		}
	},
		
	/**
	 * Retourne la liste des ateliers déclarés d'un server (triés dans l'ordre alpha des codes).
	 * 
	 */
	getServerWsps: function (pIdServer){
		var vServer = this.fListServer[pIdServer];
		if(vServer) return vServer.getWsps();
		return null;
	},
	
	/**
	 * Reference un nouveau Server et le retourne
	 */
	addServer: function (pUrl, pLogin, pTitle, pPassword){
		try{
			var vServer = this.searchServer(pUrl, pLogin);
			if(vServer){// le serveur a déjà été référencé
				vServer.setTitle(pTitle);
				return vServer; 
			}else{
				vServer = new scWspServer(pUrl, pTitle, pLogin, pPassword);
				this.fListServer[vServer.getId()] = vServer;
				this.xSaveConfig();
				this.xFireWspRegEvents("create", vServer.getId(), null);
				return vServer;
			}
		}catch (e){
			debug("sWspRegistryService > addServer (impossible de créer le server '"+pUrl+" - "+pLogin+") : " + e);
			return null;
		}
	},
	
	/**
	 * Cherche un serveur dans la liste des serveurs selon son login et son password
	 * @return scWspServer ou null
	 */
	searchServer: function (pUrl, pLogin){
		try{
			// on vérifie que le serveur n'a pas déjà été référencé
			for(var vCdServer in this.fListServer){
				if(this.fListServer[vCdServer].compareSrvs(pUrl, pLogin)){
					return this.fListServer[vCdServer];
				}
			}
			return null;
		}catch (e){
			debug("sWspRegistryService > searchServer : " + e);
			return null;
		}
	},
	/**
	 * Cherche un serveur dans la liste des serveurs
	 * @return scWspServer ou null
	 */
	getServer: function (pIdServer){
		try{
			return this.fListServer[pIdServer];
		}catch (e){
			debug("sWspRegistryService > getServer : " + e);
			return null;
		}
	},
	
	/**
	 * Crée et reference un nouveau WSP.
	 * Retoune false si échec
	 */
	addWsp: function (pIdServer, pCode, pComment, pActive){
		try{
			var vServer = this.fListServer[pIdServer];
			if(vServer){
				var vActif = (pActive!=null) ? pActive : true;
				if(vServer.getWsp(pCode)){// le serveur existe déjà => on enregistre juste ses propriétés potentiellement modifiées
					this.setActiveWsp(pIdServer, pCode, vActif);
					//this.setCommentWsp(pIdServer, pCode, pComment);
					return true;
				}else{
					var vNewWsp = vServer.addWsp(pCode, pComment, vActif);
					this.xSaveConfig();
					this.xFireWspRegEvents("create", pIdServer, vNewWsp);
					return true;
				}
			}
			return false;
		}catch (e){
			debug("sWspRegistryService > addWsp (impossible de créer le wsp '"+pCode+" - "+pIdServer+"') : " + e);
			return false;
		}
	},
	
	/**
	 * renseigne le titre d'un Server.
	 */
	setTitleServer: function (pIdServer, pTitle){
		try{
			this.fListServer[pIdServer].setTitle(pTitle);
			this.xSaveConfig();
			this.xFireWspRegEvents("update", pIdServer, null);
			return true;
		}catch (e){
			debug("sWspRegistryService > setTitleServer : " + e);
			return false;
		}
	},
	
	/**
	 * Renseigne le l'enregistrement ou non du password
	 */
	 setServerSavePsswdFlag: function (pIdServer, pFlag){
		try{
			this.fListServer[pIdServer].setSavePsswdFlag(pFlag);
			this.xSaveConfig();
			this.xFireWspRegEvents("update", pIdServer, null);
			return true;
		}catch (e){
			debug("sWspRegistryService > setServerSavePsswdFlag : " + e);
			return false;
		}
	},

	/**
	 * renseigne le password d'un Server.
	 */
	setServerConnexionSetting: function (pIdServer, pPassword){
		try{
			var vServer = this.fListServer[pIdServer];
			//if( ! vServer) vServer = this.addServer(pUrlServer, null);
			if(vServer){
				vServer.setConnexion(pPassword);
				this.xSaveConfig();
				this.xFireWspRegEvents("update", pIdServer, null);
				return true;
			}else{
				return false;
			}
		}catch (e){
			debug("sWspRegistryService:setServerConnexionSetting (impossible de changer le user/password du server '"+pUrlServer+"') : "+e);
			return false;
		}
	},
	
	/**
	 * rend actif ou pas un atelier.
	 */
	setActiveWsp: function (pIdServer, pCode, pActive){
		try{
			var vWsp = this.getWsp(pIdServer, pCode);
			if(vWsp.isActive()!=pActive){
				vWsp.setActive(pActive);
				this.xSaveConfig();
				if(pActive){
					this.xFireWspRegEvents("update", pIdServer, vWsp);
				}else{// desactivation <=> suppression dans l'IHM
					this.xFireWspRegEvents("remove", pIdServer, vWsp);
				}
			}
			return true;
		}catch (e){
			debug("sWspRegistryService > setActiveWsp : " + e);
			return false;
		}
	},
	
	/**
	 * Supprime un Server.
	 */
	removeServer: function (pIdServer){
		try{
			if(pIdServer in this.fListServer){
				var vServer  = this.fListServer[pIdServer];
				vServer.quit();
				delete this.fListServer[pIdServer];
				this.xSaveConfig();
				this.xFireWspRegEvents("remove", pIdServer, null);
				return true;
			}
			return false;
		}catch (e){
			debug("sWspRegistryService > removeServer : " + e);
			return false;
		}
	},
			
	/**
	 * Supprime un Atelier.
	 */
	removeWsp: function (pIdServer, pCode){
		try{
			var vServer = this.fListServer[pIdServer];
			if(vServer) {
				var vWsp = vServer.removeWsp(pCode);
				if(vWsp) {
					this.xSaveConfig();
					this.xFireWspRegEvents("remove", pIdServer, vWsp);
					return true;
				}
			}
			return false;
		}catch (e){
			debug("sWspRegistryService > removeWsp : " + e);
			return false;
		}
	},
	
	/**
	 * Récupère l'objet scIDataProvider d'un URL déclarée dans le wspRegistry.
	 */
	getDataProvider: function (pIdServer){
		try{
			var vServer = this.fListServer[pIdServer];
			if(vServer)	return vServer.getDataProvider();
			return null;
		}catch (e){
			debug("sWspRegistryService > getDataProvider : " + e);
			return null;
		}
	},
	
	/**
	 * Enregistre un listener sur les modifs du registre des ateliers.
	 * Le listener doit implémenter l'interface "scIWspRegListener".
	 * avec la fonction : 
	 * handleWspRegUpdated(in string pTypeEvent, in string pIdServer, in scIWsp pWsp)
	 */
	addWspRegListener: function (pListener){
		for(var i = 0; i < this.fListeners.length; i++) {
			if(this.fListeners[i] == pListener) return;
		}
		this.fListeners.push(pListener);
	},

	/**
	 * Elimine un listener sur les modifs du registre des ateliers.
	 */
	removeWspRegListener: function (pListener){
		for(var i = 0; i < this.fListeners.length; i++) {
			if(this.fListeners[i] == pListener) {
				this.fListeners.splice(i, 1);
				break;
			}
		}
		if(this.fListeners.length == 0){
			//Plus d'abonnés, on purge tous les servers.
			for(var vUrl in this.fListServer){
				this.fListServer[vUrl].quit();
			}
		}
	},
	
	fireUpdateEvent: function (pIdServer, pCodeWsp){
		var vWsp = (pCodeWsp) ? this.getWsp(pIdServer, pCodeWsp) : null;
		if(vWsp) vWsp.initDef();
		return this.xFireWspRegEvents("update", pIdServer, vWsp);
	},
	
	fireFocusEvent: function (pIdServer, pCodeWsp){
		var vWsp = (pCodeWsp) ? this.getWsp(pIdServer, pCodeWsp) : null;
		if(vWsp) vWsp.initDef();
		return this.xFireWspRegEvents("focus", pIdServer, vWsp);
	},
	
	
	fireUnloadEvent: function (pIdServer, pCodeWsp){
		var vWsp = (pCodeWsp) ? this.getWsp(pIdServer, pCodeWsp) : null;
		if(vWsp) vWsp.initDef();
		return this.xFireWspRegEvents("unload", pIdServer, vWsp, true);
	},
	
	/**
	 * Internes
	 */
	xFireWspRegEvents: function (pTypeEvent, pIdServer, pWsp, pStopIfUncomplete){
		var vIsFireComplete = true;
		for(var i = 0; i < this.fListeners.length; i++) {
			try{
				var vIsComplete = this.fListeners[i].handleWspRegUpdated(pTypeEvent, pIdServer, pWsp);
				if(!vIsComplete) vIsFireComplete = false;
				if(pStopIfUncomplete && !vIsComplete) return false;
			}catch(e){
				debug("Echec au traitement d'un handleWspRegUpdated ::"+e);
			}
		}
		return vIsFireComplete;
	},
	
	xGetCurrentDomConfig: function (){
		try{
			var vDomDocument = Components.classes["@mozilla.org/xul/xul-document;1"].createInstance(Components.interfaces.nsIDOMDocument);
			var vListeWsp=vDomDocument.createElement('listWsp');
				for(var vServerId in this.fListServer){
					var vServer = this.fListServer[vServerId];
					var vServerNode = vDomDocument.createElement('server');
					vServerNode.setAttribute('url', vServer.getUrl());
					vServerNode.setAttribute('title', vServer.getTitle());
					vServerNode.setAttribute('savePassword', vServer.getSavePsswdFlag());
					if (vServer.isLocal) vServerNode.setAttribute('type', 'local');
					if (vServer.fLogin) vServerNode.setAttribute('login', vServer.fLogin);
					
					for(var vCdWsp in vServer.fWsps) {
						var vWsp = vServer.getWsp(vCdWsp);
						var vWspNode = vDomDocument.createElement('wsp');
						vWspNode.setAttribute('code', vCdWsp);
						vWspNode.setAttribute('comment', vWsp.getComment());
						vWspNode.setAttribute('actif', vWsp.isActive());
						vServerNode.appendChild(vWspNode);
					}
					vListeWsp.appendChild(vServerNode);
				}
			vDomDocument.appendChild(vListeWsp);
			return vDomDocument;
		}catch(e){
			debug("sWspRegistryService:xGetCurrentDomConfig (Echec au calcul du dom de config) : "+e);
			return null;
		}	
	},
	
	xSaveConfig: function (){
		try{
			var vOutputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance( Components.interfaces.nsIFileOutputStream );
			vOutputStream.init(this.fFile, 0x04 | 0x08 | 0x20, 0644, 0 );
			var vDomDocument = this.xGetCurrentDomConfig();
			var vSerializer = Components.classes["@mozilla.org/xmlextras/xmlserializer;1"].createInstance(Components.interfaces.nsIDOMSerializer);
			var vData = vSerializer.serializeToString(vDomDocument);
			vOutputStream.write(vData, vData.length );
			vOutputStream.close();
			return true;
		}catch(e){
			debug("sWspRegistryService > xSaveConfig (Echec à l'écriture du fichier de configuration) : " + e);
			return false;
		}	
	},

    QueryInterface: function(pIId) {
        if (!pIId.equals(Components.interfaces.nsISupports) &&
            !pIId.equals(WSREGISTRYSERVICE_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};


/**
  * Définition du scWspServer
  **/
function scWspServer(pUrl, pTitle, pLogin, pPassword){
	var vDefaultUrlLocal = gPrefs.getCharPref("scenari.urlServerLocal").length>0 ? gPrefs.getCharPref("scenari.urlServerLocal") : null;
	this.fIniUrl = pUrl;
	this.isLocal = false;
	if(vDefaultUrlLocal && pUrl.indexOf(vDefaultUrlLocal)==0) this.isLocal = true;
	this.fDataProvider = null;
	this.fTitle = null;
	this.fLogin = (pLogin==null ? "" : pLogin);
	var vLogin = this.xGetCurrentLogin();
	if(pPassword){
		this.fPassword = pPassword;
		if(vLogin) nsLoginManager.removeLogin(vLogin);
	}else if(vLogin){// on essaye de le récupérer dans le service password
		this.fPassword = vLogin.password;
	}
	this.fId = pUrl + "*" + pLogin;
	this.fWsps = {};
	this.setTitle(pTitle);
	this.fSavePasswd = true;
}
scWspServer.prototype = {
	/**
	 * Retourne le dataProvider de ce serveur
	 * 	@return : null si un pb a été rencontré
	 */
	getDataProvider: function(){
		if(this.fDataProvider==null) {
			try{
				this.fDataProvider = Components.classes["@scenari.com/httpdataprovider;1"].createInstance(Components.interfaces.scIDataProvider);
				this.fDataProvider.init(this.fIniUrl, null, this.fLogin, this.fPassword, this);
			}catch (e){
				debug("sWspRegistryService:getDataProvider (Impossible de créer le serveur '"+this.fIniUrl+"') : "+e);
				this.fDataProvider = null;
			}
		}
		//debug("scWspServer.prototype.getDataProvider::"+this.fDataProvider.getIniUrl()+" local="+this.fDataProvider.isLocal());
		return this.fDataProvider;
	},
	/**
	 * Retourne l'id de ce serveur.
	 */
	getId: function(){
		try{
			return this.fId;
		}catch (e){
			debug("getId : " + e);
		}
	},
	/**
	 * Retourne le titre
	 */
	getTitle: function(){
		try{
			return this.fTitle;
		}catch (e){
			debug("getTitle : " + e);
		}
	},
	getSavePsswdFlag: function(){
		try{
			return this.fSavePasswd;
		}catch (e){
			debug("getSavePsswdFlag : " + e);
		}
	},
	/**
	 * Retourne l'URL
	 */
	getUrl: function(){
		try{
			return this.fIniUrl;
		}catch (e){
			debug("getUrl : " + e);
		}
	},
	/**
	 * Retourne le user
	 */
	getUser: function(){
		try{
			return this.fLogin;
		}catch (e){
			debug("getUser : " + e);
		}
	},
	/**
	 * Retourne le password
	 */
	getPassword: function(){
		try{
			return this.fPassword;
		}catch (e){
			debug("getPassword : " + e);
		}
	},
	/**
	 * Retourne la liste des ateliers déclarés d'un server (triés dans l'ordre alpha des codes).
	 */
	getWsps: function (){
		try{
			var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
			var vArray = [];
			for(var vCdWsp in this.fWsps) vArray.push(vCdWsp);
			vArray.sort(function(p1, p2){return p1.localeCompare(p2);});
			for(var i = 0; i < vArray.length; i++){
				vArr.AppendElement(this.fWsps[vArray[i]].QueryInterface(Components.interfaces.nsISupports));
			}
			return vArr;
		}catch(e){
			debug("scWspServer.prototype.getWsps : " + e);
		}
	},
	
	/**
	 * Internes
	 */
	setConnexion: function(pPassword){
		try{
			this.fPassword = pPassword;
			var vDataServer = this.getDataProvider();
			vDataServer.setPassword(pPassword);
			// Gestion de l'enregistrement du password
			if(pPassword && this.fSavePasswd){
				var vLogin = this.xGetCurrentLogin();
				var vNewLogin = new nsLoginInfo(this.getUrl(), null, "SCENARI", this.getUser(), pPassword, "", "");
				if(vLogin) nsLoginManager.modifyLogin(vLogin, vNewLogin)
				else nsLoginManager.addLogin(vNewLogin);
			}
		}catch (e){
			debug("scWspServer.prototype.setConnexion : " + e);
		}
	},
	setSavePsswdFlag: function(pFlag){
		try{
			this.fSavePasswd = pFlag;
			// Gestion de l'enregistrement du password
			var vLogin = this.xGetCurrentLogin();
			if(pFlag){// enr
				if(this.getPassword() && !vLogin){
					var vNewLogin = new nsLoginInfo(this.getUrl(), null, "SCENARI", this.getUser(), this.getPassword(), "", "");
					nsLoginManager.addLogin(vNewLogin);
				}
			}else{//supp
				if(vLogin) nsLoginManager.removeLogin(vLogin);
			}
		}catch (e){
			debug("scWspServer.prototype.setSavePsswdFlag : " + e);
		}
	},
	setTitle: function(pTitle){
		try{
			if(this.isLocal){
				this.fTitle = "Ateliers locaux";
			}else if(pTitle && pTitle!=""){
				this.fTitle = pTitle;
			}else{
				this.fTitle = this.fIniUrl;
			}
		}catch (e){
			debug("scWspServer.prototype.setTitle : " + e);
		}
	},
	quit: function(){
		if(this.fDataProvider) {
			this.fDataProvider.quit();
			this.fDataProvider = null;
		}
	},
	getWsp: function(pCode) {
		return this.fWsps[pCode];
	},
	addWsp: function(pCode, pComment, pActive){
		var vNewWsp = new scWsp(this.getId(), pCode, pComment, pActive);
		this.fWsps[pCode] = vNewWsp;
		return vNewWsp;
	},
	removeWsp: function(pCdWsp){
		var vWsp = this.fWsps[pCdWsp];
		if(vWsp) delete this.fWsps[pCdWsp];
		return vWsp;
	},
	compareSrvs: function(pUrl, pLogin){
		var vLogin = (pLogin==null ? "" : pLogin);
		if(this.fIniUrl==pUrl && this.fLogin==vLogin) return true;
		return false;
	},
	xGetCurrentLogin: function(){
		try{
			var vLogins = nsLoginManager.findLogins({}, this.getUrl(), null, "SCENARI");
			for (var i = 0; i < vLogins.length; i++) {
				if (vLogins[i].username == this.getUser()) return vLogins[i];
			}
			return null;
		}catch (e){
			debug("scWspServer.prototype.xGetCurrentLogin : " + e);
		}
	},
    QueryInterface: function(pIId) {
        if (!pIId.equals(Components.interfaces.nsISupports) &&
            !pIId.equals(WSPSERVER_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};



/**
  * Définition du scWsp
  **/
function scWsp(pServerId, pCode, pComment, pActive) {
	this.fServerId	= pServerId;
	this.fCode		= pCode;
	this.fComment	= pComment;
	this.fActive	= pActive;
	this.fWspType	= null;
	this.fWspTypeUi = null;
	this.fWspOptionUiCollection = null;
}
scWsp.prototype = {
	
	/**
	 * Retourne le code de cet atelier (vu par le serveur).
	 * 
	 */
	getCode: function(){
		return this.fCode;
	},
	/**
	 * Retourne le dataProvider de données de cet atelier.
	 * 
	 */
	getDataProvider: function(){
		return this.getServer() ? this.getServer().getDataProvider() : null;
	},
	/**
	 * Retourne le wspServeur de cet atelier.
	 * 
	 */
	getServer: function(){
		var vWspReg = Components.classes["@scenari.com/wspregistryservice;1"].getService(Components.interfaces.scIWspRegistryService);
		return vWspReg.getServer(this.fServerId);
	},
	/**
	 * Retourne l'url du server de données de cet atelier.
	 * 
	 */
	getUrlServer: function(){
		return this.getServer() ? this.getServer().getUrl() : null;
	},
	/**
	 * Retourne l'url du server de données de cet atelier.
	 * 
	 */
	getIdServer: function(){
		return this.fServerId;
	},
	/**
	 * Retourne le titre du serveur.
	 * 
	 */
	getTitleServer: function(){
		return this.getServer() ? this.getServer().getTitle() : null;
	},
	/**
	 * Retourne le commentaire stocké au niveau du profil utilisateur.
	 * 
	 */
	getComment: function(){
		return this.fComment;
	},
	
	/**
	 * wsp actif/inactif
	 */
	isActive: function(){
		return this.fActive;
	},
	
	/**
	 * Retourne l'objet wspTypeUi
	 */
	getWspTypeUi: function(){
		if( ! this.fWspTypeUi) {
			try {
				var vWspType = this.getWspType();
				//Si le wspType n'est pas encore chargé, impossible d'obtenir le wspTypeUi.
				if( ! vWspType) return null;
				var vWspTypeUri = vWspType.getAttribute("uri");
				if(vWspTypeUri) {
					var vPackRegSvc = Components.classes["@scenari.com/packregistryservice;1"].getService(Components.interfaces.scIPackRegistryService);
					this.fWspTypeUi = vPackRegSvc.getWspTypeUi(vWspTypeUri);
				}
			}catch(e){
				debug("scWsp > getWspTypeUi :: " + e);
			}
		}
		return this.fWspTypeUi;
	},
	/**
	 * Retourne une collection d'objets scIWspOptionUi
	 */
	getWspOptionUiList: function(){
		if( ! this.fWspOptionUiCollection){
			try{
				var vWspType = this.getWspType();
				//Si le wspType n'est pas encore chargé, impossible d'obtenir la liste des wspOptionUi.
				if( ! vWspType) return null;
				this.fWspOptionUiCollection = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
				var vOptionList = vWspType.getElementsByTagName("wspOption");
				var vPackRegSvc = Components.classes["@scenari.com/packregistryservice;1"].getService(Components.interfaces.scIPackRegistryService);
				for(var i=0; i<vOptionList.length; i++) {
					var vOptionUri = vOptionList[i].getAttribute('uri');
					if(vOptionUri) {
						var vOptionUi = vPackRegSvc.getWspOptionUi(vOptionUri);
						if(vOptionUi) this.fWspOptionUiCollection.AppendElement(vOptionUi);
					}
				}
			}catch(e){
				debug("scWsp > getWspOptionUiList :: " + e);
				return null;
			}
		}
		return this.fWspOptionUiCollection;
	},
	
  /**
	*  getMainviewOverlayList : retourne la liste des overlays déclarés pour le pPack et pModel
	*  @param pPack 
	*  @param pModel
	**/
	getMainviewOverlayList : function(pPack, pModel) {
		try{
			var vWspOptionList = this.getWspOptionUiList();
			if(vWspOptionList && pPack && pModel){
				var vFinalOvListTab = Components.classes["@mozilla.org/array;1"].createInstance(Components.interfaces.nsIMutableArray);
				for(var ii = 0; ii<vWspOptionList.Count(); ii++) {
					var vWspOptionUi = vWspOptionList.GetElementAt(ii).QueryInterface(Components.interfaces.scIWspOptionUi);
					if(vWspOptionUi){
						var vWspOptionOvTab = vWspOptionUi.getMainviewOverlayList(pPack, pModel);
						if(vWspOptionOvTab){
							var vWspOptionOvTabEnum = vWspOptionOvTab.enumerate();
							//debug("vWspOptionOvTabEnum :: "+listProperties(vWspOptionOvTab));
							while(vWspOptionOvTabEnum.hasMoreElements()) {
							      var vOv= vWspOptionOvTabEnum.getNext().QueryInterface(Components.interfaces.nsISupportsCString);
							      vFinalOvListTab.appendElement(vOv, false);
							}
						}
					}
				}
				return vFinalOvListTab;
			}
			return null;
		}catch(e){
			debug("scWspRegistryService > getMainviewOverlayList :: " + e);
			return null;
		}
	},
	
	/**
	 * Internes
	 */
	initDef: function(){
		// réinitialisation des objets de ce wsp
		this.fWspType = null;
		this.fWspTypeUi = null;
		this.fWspOptionUiCollection = null;
	},
	setActive: function(pActive){
		this.fActive=pActive;
	},
	setComment: function(pComment){
		if(pComment!=null) this.fComment=pComment;
	},
	getWspType: function(){
		try{
			if(this.fWspType){
				return this.fWspType;
			}else{
				if(this.getDataProvider().isProviderReady()){
					//interroge le serveur pour obtenir le wspType
					var vInfoWsp = this.getDataProvider().getDomFromService("/u/adminWsp?cdaction=InfoWsp&param=" + this.getCode());
					if(vInfoWsp && vInfoWsp.documentElement) {
						var vStatus = vInfoWsp.documentElement.getAttribute('status');
						if(vStatus=="ok"){
							var vWspType = vInfoWsp.documentElement.getElementsByTagName("wspType")[0];
							this.fWspType = vWspType;
							return vWspType;
						}
					}
				}
			}
			return null;
		}catch(e){
			debug("scWsp > getWspType :: " + e);
			return null;
		}
	},
    QueryInterface: function(pIId) {
        if (!pIId.equals(Components.interfaces.nsISupports) &&
            !pIId.equals(WSP_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};


/**
  * fctions internes
  **/
function debug(pText) {
	var vConsoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
	vConsoleService.logStringMessage(pText);
}

function listProperties(pObj){
	var vRes = "";
	var vProp = null;
	for (vProp in pObj) {
		try {
			vRes += vProp +'(' + pObj[vProp]+ ')'+ "\n";
		} catch(e){
			vRes += vProp +' -> toString in error\n';
		}
	}
	return vRes;
}

function getXml(pElement){
	var vSerializer = Components.classes["@mozilla.org/xmlextras/xmlserializer;1"].createInstance(Components.interfaces.nsIDOMSerializer);
	return pElement ? vSerializer.serializeToString(pElement) : "";
}

gPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);


/**
  * Module
  **/
var sModule = {
    registerSelf: function(compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);

        compMgr.registerFactoryLocation(WSREGISTRYSERVICE_CID, 
                                        "scWspRegistryService JS component", 
                                        WSREGISTRYSERVICE_CONTRACTID, 
                                        fileSpec, 
                                        location,
                                        type);
    },

    getClassObject: function(compMgr, cid, iid) {
        if (!cid.equals(WSREGISTRYSERVICE_CID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return sWspRegFactory;
    },

    canUnload: function(compMgr) { return true; }
};

var sWspRegFactory = {
    createInstance: function(outer, iid) {
        if (outer != null)
            throw Components.results.NS_ERROR_NO_AGGREGATION;
    
        if (!iid.equals(WSREGISTRYSERVICE_IID) &&
            !iid.equals(Components.interfaces.nsISupports))
            throw Components.results.NS_ERROR_INVALID_ARG;

        return new scWspRegistryService();
    }
}

/** Module initialisation */
function NSGetModule(comMgr, fileSpec) { return sModule; }

