/*
 * LICENCE[[
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1/CeCILL 2.O 
 *
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License 
 * for the specific language governing rights and limitations under the 
 * License. 
 * 
 * The Original Code is kelis.fr code. 
 * 
 * The Initial Developer of the Original Code is 
 * sylvain.spinelli@kelis.fr 
 * 
 * Portions created by the Initial Developer are Copyright (C) 2009
 * the Initial Developer. All Rights Reserved. 
 * 
 * Contributor(s): 
 * 
 * 
 * Alternatively, the contents of this file may be used under the terms of 
 * either of the GNU General Public License Version 2 or later (the "GPL"), 
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"), 
 * or the CeCILL Licence Version 2.0 (http://www.cecill.info/licences.en.html), 
 * in which case the provisions of the GPL, the LGPL or the CeCILL are applicable 
 * instead of those above. If you wish to allow use of your version of this file 
 * only under the terms of either the GPL or the LGPL, and not to allow others 
 * to use your version of this file under the terms of the MPL, indicate your 
 * decision by deleting the provisions above and replace them with the notice 
 * and other provisions required by the GPL or the LGPL. If you do not delete 
 * the provisions above, a recipient may use your version of this file under 
 * the terms of any one of the MPL, the GPL, the LGPL or the CeCILL.
 * ]]LICENCE
 */
 
const Cc = Components.classes;
const Ci = Components.interfaces;
Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

const PACK_LIST_URI = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI("chrome://scenaricms/content/wspmgr/packlist.xml", null, null);

		
function scPackRegistryService() {
	try {
		this.loadRegistry();
		Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService).addObserver(this, "chrome-flush-caches", false);
	}catch(e){
		debug("init failed : "+e);
	}
}
scPackRegistryService.prototype = {
	
	/** Retourne l'Element DOM racine du pack de code pCode. */
	getPack : function(pCode) {
		return fPackMapByCode[pCode];
	},
	
	/** Retourne l'Element DOM du WspType d'uri pUri. */
	getWspType : function(pUri) {
		return this.fWspTypeMapByUri[pUri];
	},

	/** Retourne l'Element DOM du WspOption d'uri pUri. */
	getWspOption : function(pUri) {
		return this.fWspOptionMapByUri[pUri];
	},

	/** Retourne le WspTypeUi d'uri pUri. */
	getWspTypeUi : function(pUri) {
		return this.fWspTypeUiMapByUri[pUri];
	},

	/** Retourne le WspOptionUi d'uri pUri. */
	getWspOptionUi : function(pUri) {
		return this.fWspOptionUiMapByUri[pUri];
	},
	
	/** Retourne une collection d'éléments DOM de tous les WspType déclarés */
	getWspTypeList : function() {
		var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
		for each(var vWsp in this.fWspTypeMapByUri) vArr.AppendElement(vWsp.QueryInterface(Components.interfaces.nsIDOMElement));
		return vArr;
	},

	/** Retourne une collection d'éléments DOM de tous les WspOption déclarés */
	getWspOptionList : function() {
		var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
		for each(var vWsp in this.fWspOptionMapByUri) vArr.AppendElement(vWsp.QueryInterface(Components.interfaces.nsIDOMElement));
		return vArr;
	},
	
    /** Retourne une collection scIWspTypeUi de tous les WspTypeUi déclarés. */
    getWspTypeUiList : function(){
		var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
		for each(var vWspUi in this.fWspTypeUiMapByUri) vArr.AppendElement(vWspUi);
		return vArr;
    },

    /** Retourne une collection de scIWspOptionUi de tous les WspOptionUi déclarés. */
    getWspOptionUiList : function(){
		var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
		for each(var vWspUi in this.fWspOptionUiMapByUri) vArr.AppendElement(vWspUi);
		return vArr;
    },
	
	/** Retourne true si au moins un wspType a été déclaré dans un pack */
    hasWspType : function() {
        return this.fHasWspType;
    },
	

	/** Recherche wspTypeUi ou le wspOptionUi correspondant à la key pKey et la plus proche de la langue pLang. */
	findWspUi : function(pKey, pLang) {
		var vWspUiList = this.fWspUiMapByKey[pKey];
		if( ! vWspUiList) return null;
		var vResult = null;
		for each(var vWspUi in vWspUiList) {
			var vLang = vWspUi.getLang();
			if( ! vLang || (pLang||"").indexOf(vLang)==0) {
				//La langue match
				if( ! vResult || vResult.getLang().length < (vLang||"").length) {
					//1er trouvé ou la langue est plus précise que la précédente trouvée
					vResult = vWspUi;
				}
			}
		}
		if(vResult==null) {
			//Pas trouvé, donc la langue par défaut n'existe pas.
			//On cherche une langue anglaise en 1er
			for each(var vWspUi in vWspUiList) {
				if(vWspUi.getLang().indexOf("en")==0) {
					vResult = vWspUi;
					break;
				}
			}
		}
		if(vResult==null) {
			//On cherche une langue française en 2ème
			for each(var vWspUi in vWspUiList) {
				if(vWspUi.getLang().indexOf("fr")==0) {
					vResult = vWspUi;
					break;
				}
			}
		}
		if(vResult==null) {
			//Toujours rien, on prend la 1ère langue de la liste.
			vResult = vWspUiList[0];
		}
		return vResult;
	},
	
    /** Retourne une collection de scIWspOptionUi fils de pParentKey et dans la langue la plus proche de pPreferedLang. */
    findWspOptionUiList: function (pParentKey, pPreferedLang){
		var vArr = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsICollection);
    	if(pParentKey) for each (var vWspUiArray in this.fWspUiMapByKey) {
    		var vFirstWspUi = vWspUiArray[0];
    		if(! vFirstWspUi || ! vFirstWspUi.isOptionUi()) continue;
    		vFirstWspUi = vFirstWspUi.QueryInterface(Components.interfaces.scIWspOptionUi);
    		if(vFirstWspUi.getParentKey()==pParentKey) {
    			//Option valide pour pParentKey.
    			var vPreferedWspOptionUi = this.findWspUi(vFirstWspUi.getKey(), pPreferedLang);
    			if(vPreferedWspOptionUi) vArr.AppendElement(vPreferedWspOptionUi);
    		}
    	}
		return vArr;
    },
	
	observe: function (pSubject, pTopic, pData) {
	    switch (pTopic) {
	    case "chrome-flush-caches":
	    	//On recharge les packs.
	    	this.loadRegistry();
	    }
	},
	
	loadRegistry : function(){
		//debug("loadRegistry");
		this.fPackMapByCode = {};
		this.fHasWspType = false;
		this.fWspTypeMapByUri = {};
		this.fWspOptionMapByUri = {};
		this.fWspTypeUiMapByUri = {};
		this.fWspOptionUiMapByUri = {};
		this.fWspUiMapByKey = {};
		
		var vOverlayList= Cc["@mozilla.org/chrome/chrome-registry;1"].getService(Ci.nsIXULOverlayProvider).getXULOverlays(PACK_LIST_URI);
		while(vOverlayList.hasMoreElements()){
			//Pour tous les packs déclarés...
			var vUriPack = vOverlayList.getNext().QueryInterface(Components.interfaces.nsIURI);
			try {
				var vPackDom = getDomFromLocalFileUrl(vUriPack.spec);
				var vPackCode = vPackDom.documentElement.getAttribute("code");
				if(vPackCode) {
					if(this.fPackMapByCode[vPackCode]) debug("WARNING : Pack code '"+vPackCode+"' declared twice : "+vUriPack.spec+" and "+this.fPackMapByCode[vPackCode].ownerDocument.documentURI);
					this.fPackMapByCode[vPackCode] = vPackDom.documentElement;
				}
				var vCh = vPackDom.documentElement.firstElementChild;
				while(vCh) {
					var vUri = vCh.getAttribute("uri");
					try {
						var vWspUi = null;
						switch(vCh.localName) {
						case "wspType" :
							if(this.fWspTypeMapByUri[vUri]) debug("WARNING : WspType uri '"+vUri+"' declared twice : "+vUriPack.spec+" and "+this.fWspTypeMapByUri[vUri].ownerDocument.documentURI);
							this.fHasWspType = true;
							this.fWspTypeMapByUri[vUri] = vCh;
							break;
						case "wspOption" :
							if(this.fWspOptionMapByUri[vUri]) debug("WARNING : WspOption uri '"+vUri+"' declared twice : "+vUriPack.spec+" and "+this.fWspOptionMapByUri[vUri].ownerDocument.documentURI);
							this.fWspOptionMapByUri[vUri] = vCh;					
							break;
						case "wspTypeUi" :
							if(this.fWspTypeUiMapByUri[vUri]) debug("WARNING : WspTypeUi uri '"+vUri+"' declared twice : "+vUriPack.spec+" and "+this.fWspTypeUiMapByUri[vUri].ownerDocument.documentURI);
							var vComponent = vCh.getAttribute('component');
							vWspUi = Components.classes[vComponent].createInstance(Components.interfaces.scIWspUi);
							vWspUi.init(vCh);
							this.fWspTypeUiMapByUri[vUri] = vWspUi.QueryInterface(Components.interfaces.scIWspTypeUi);
							break;
						case "wspOptionUi" :
							if(this.fWspOptionUiMapByUri[vUri]) debug("WARNING : WspOptionUi uri '"+vUri+"' declared twice : "+vUriPack.spec+" and "+this.fWspOptionUiMapByUri[vUri].ownerDocument.documentURI);
							var vComponent = vCh.getAttribute('component');
							vWspUi = Components.classes[vComponent].createInstance(Components.interfaces.scIWspUi);
							vWspUi.init(vCh);
							this.fWspOptionUiMapByUri[vUri] = vWspUi.QueryInterface(Components.interfaces.scIWspOptionUi);					
							break;
						}
						if(vWspUi) {
							//On a créé un WspUi, on ajoute à la map par key.
							var vKey = vCh.getAttribute("key");
							if(vKey) {
								var vWspUiList = this.fWspUiMapByKey[vKey];
								if( ! vWspUiList) vWspUiList = this.fWspUiMapByKey[vKey] = [];
								vWspUiList.push(vWspUi);
							}
						}
					} catch(e){
						debug("Loading " + vCh.localName + " with uri '" + vUri + "' failed : " + vUriPack.spec + " : " + e);
					}
					vCh = vCh.nextElementSibling;
				}
			} catch(e){
				debug("Loading pack failed : " + vUriPack.spec + " : " + e);
			}
		}

	},
	
	classDescription : "PackRegistryService",
	classID : Components.ID("{2cd0c310-e127-44d0-88fc-4435c9ab4d4a}"),
	contractID : "@scenari.com/packregistryservice;1",
	QueryInterface : XPCOMUtils.generateQI([Ci.scIPackRegistryService, Ci.nsIObserver])
};


function getDomFromLocalFileUrl(pUrl) {
	try{
		var vReq = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"].createInstance(Components.interfaces.nsIXMLHttpRequest);
		vReq.open("GET", pUrl, false); 
		vReq.send(null);
		var vResult = vReq.responseXML;
		if(vResult.documentElement.nodeName == "parsererror") {
			debug("Parsing url failed : '" + pUrl + "':\n " + vReq.responseText );
			return null;
		}
		return vResult;
	}catch(e){
		debug("Parsing url failed : '"+pUrl+"': "+e);
		return null;
	}
}

function debug(pText){
	var vConsoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
	vConsoleService.logStringMessage("scPackRegistryService > " + pText);
}

function NSGetModule(compMgr, fileSpec)
  XPCOMUtils.generateModule([scPackRegistryService]);