

const nsISupports              = Components.interfaces.nsISupports;

const nsICategoryManager       = Components.interfaces.nsICategoryManager;
const nsIComponentRegistrar    = Components.interfaces.nsIComponentRegistrar;
const nsICommandLine           = Components.interfaces.nsICommandLine;
const nsICommandLineHandler    = Components.interfaces.nsICommandLineHandler;
const nsIFactory               = Components.interfaces.nsIFactory;
const nsIModule                = Components.interfaces.nsIModule;
const nsIPrefBranch            = Components.interfaces.nsIPrefBranch;
const nsISupportsString        = Components.interfaces.nsISupportsString;
const nsIWindowWatcher         = Components.interfaces.nsIWindowWatcher;
const nsIDOMWindow			   = Components.interfaces.nsIDOMWindow;

const prefLastVersionRun	   = "scenari.app.lastVersionRun"; 



var scClh = {

  /* nsISupports */
  QueryInterface : function clh_QI(iid) {
    if (iid.equals(nsICommandLineHandler) ||
        iid.equals(nsIFactory) ||
        iid.equals(nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsICommandLineHandler */
  handle : function clh_handle(pCmdLine) {
	if (pCmdLine.preventDefault) return;
	pCmdLine.preventDefault = false;//on continue le démarrage normal
	
	var vPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(nsIPrefBranch);
	var vConsoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
	var vWinWatch = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(nsIWindowWatcher);
	var vInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
	
	try {

		vPrefs.setCharPref(prefLastVersionRun, vInfo.version);
	} catch (e) {
		vConsoleService.logStringMessage("init Failed : "+e);
	}
	
  },

  helpInfo : "SCENARIapp - mCore",

  /* nsIFactory */
  createInstance : function mdh_CI(outer, iid) {
    if (outer != null) throw Components.results.NS_ERROR_NO_AGGREGATION;
    return this.QueryInterface(iid);
  },
  
  lockFactory : function mdh_lock(lock) {
    /* no-op */
  }
};

const clh_contractID = "@scenari/scenariapp-xxx-clh;1";
const clh_CID = Components.ID("{3CAE0595-E91E-402C-8936-5A886A7DE4FF}");

var Module = {
  /* nsISupports */
  QueryInterface : function mod_QI(iid) {
    if (iid.equals(nsIModule) || iid.equals(nsISupports)) return this;
    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsIModule */
  getClassObject : function mod_gch(compMgr, cid, iid) {
    if (cid.equals(clh_CID))  return scClh.QueryInterface(iid);
    throw components.results.NS_ERROR_FAILURE;
  },

  registerSelf : function mod_regself(compMgr, fileSpec, location, type) {
    var compReg = compMgr.QueryInterface(nsIComponentRegistrar);
    compReg.registerFactoryLocation(clh_CID,
                                    "scClh",
                                    clh_contractID,
                                    fileSpec,
                                    location,
                                    type);
    var catMan = Components.classes["@mozilla.org/categorymanager;1"].getService(nsICategoryManager);
    catMan.addCategoryEntry("command-line-handler",  "b-scenariapp-xxx", clh_contractID, true, true);
  },

  unregisterSelf : function mod_unreg(compMgr, location, type) {
    var compReg = compMgr.QueryInterface(nsIComponentRegistrar);
    compReg.unregisterFactoryLocation(clh_CID, location);
    var catMan = Components.classes["@mozilla.org/categorymanager;1"].getService(nsICategoryManager);
    catMan.deleteCategoryEntry("command-line-handler", "b-scenariapp-xxx");
  },

  canUnload : function (compMgr) {
    return true;
  }
};

function NSGetModule(compMgr, fileSpec) {
  return Module;
}



function debug(pText){
	var vConsoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
	vConsoleService.logStringMessage(pText);
}

function listProperties (pObj){
	var vRes = "";
	var vProp = null;
	for (vProp in pObj) {
		try {
			vRes += vProp +'(' + pObj[vProp]+ ')'+ "\n";
		} catch(e){
			vRes += vProp +' -> toString in error\n';
		}
	}
	return vRes;
}
