/*
 * LICENCE[[
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1/CeCILL 2.O 
 *
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License 
 * for the specific language governing rights and limitations under the 
 * License. 
 * 
 * The Original Code is utc.fr code. 
 * 
 * The Initial Developer of the Original Code is 
 * Universite de Technologie de Compiegne. 
 * 
 * Portions created by the Initial Developer are Copyright (C) 2005 
 * the Initial Developer. All Rights Reserved. 
 * 
 * Contributor(s): 
 * 
 * 
 * Alternatively, the contents of this file may be used under the terms of 
 * either of the GNU General Public License Version 2 or later (the "GPL"), 
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"), 
 * or the CeCILL Licence Version 2.0 (http://www.cecill.info/licences.en.html), 
 * in which case the provisions of the GPL, the LGPL or the CeCILL are applicable 
 * instead of those above. If you wish to allow use of your version of this file 
 * only under the terms of either the GPL or the LGPL, and not to allow others 
 * to use your version of this file under the terms of the MPL, indicate your 
 * decision by deleting the provisions above and replace them with the notice 
 * and other provisions required by the GPL or the LGPL. If you do not delete 
 * the provisions above, a recipient may use your version of this file under 
 * the terms of any one of the MPL, the GPL, the LGPL or the CeCILL.
 * ]]LICENCE
 */
 
const nsIConsoleService = Components.interfaces.nsIConsoleService;
const nsIAutoCompleteSearch = Components.interfaces.nsIAutoCompleteSearch;
const nsIAutoCompleteResult = Components.interfaces.nsIAutoCompleteResult;
const nsISupports = Components.interfaces.nsISupports;

const ACSEARCHPROXY_CONTRACTID = '@mozilla.org/autocomplete/search;1?name=scProxy';
const ACSEARCHPROXY_CID = Components.ID('{64896643-3859-4BDA-997E-5718725CE2A2}');
const ACSEARCHPROXY_IID = Components.interfaces.scIAutoCompleteSearchProxy;


/* Proxy search */
function scAutoCompleteSearchProxy() {
}

/* Definition du scAutoCompleteSearchProxy */
scAutoCompleteSearchProxy.prototype = {
	fProviders : {},
	fCounter : 1,
	fLastProviderCalled : null,
	
	/* */
    startSearch: function(pSearchString, pSearchParam, pPreviousResult, pListener) {
    	if(pSearchParam) {
    		var vIdx = pSearchParam.indexOf(":");
    		var vIdProvider = vIdx > 0 ? pSearchParam.substring(0, vIdx) : pSearchParam;
    		this.fLastProviderCalled = this.fProviders[vIdProvider];
    		if(this.fLastProviderCalled) {
    			this.fLastProviderCalled.startSearch(pSearchString, vIdx > 0 ? pSearchParam.substring(vIdx+1) : null, pPreviousResult, pListener);
    			return;
    		}
    	}
    	//Aucun provider trouvé, on repond un result vide
    	pListener.onSearchResult(this, {
            QueryInterface: function(pIID) {
              if (pIID.equals(nsIAutoCompleteResult) || pIID.equals(nsISupports))
                return this;
              throw Components.results.NS_NOINTERFACE;
            },
            results: [],
            defaultIndex: 0,
            errorDescription: null,
            matchCount: 0,
            searchResult: Components.interfaces.nsIAutoCompleteResult.RESULT_SUCCESS,
            searchString: pSearchString,
            getCommentAt: function(pIndex) {return null;},
            getImageAt: function(pIndex) {return null;},
            getStyleAt: function(pIndex) {return null;},
            getValueAt: function(pIndex) {return null;},
            removeValueAt: function(pRowIndex, pRemoveFromDb) {}
         });
    	
    },
    
    /* */
    stopSearch: function() {
    	if(this.fLastProviderCalled) this.fLastProviderCalled.stopSearch();
    },
    
    registerProvider: function(pProvider) {
    	if(pProvider == null) return;
    	var vId = "a" + (this.fCounter++);
    	this.fProviders[vId] = pProvider;
    	return vId;
    },
    
    unregisterProvider: function(pIdProvider) {
    	if(pIdProvider == null) return;
    	delete this.fProviders[pIdProvider];
    },
    
    QueryInterface: function(pIID) {
            if (!pIID.equals(ACSEARCHPROXY_IID) &&
	            !pIID.equals(nsIAutoCompleteSearch) &&
                !pIID.equals(nsISupports))
                    throw Components.results.NS_ERROR_NO_INTERFACE;
            return this;
    }
}


/* Fonctions utilitaires */
function debug(pText){
	var vConsoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(nsIConsoleService);
	vConsoleService.logStringMessage(pText);
}


/* Module (for XPCOM registration) */
var scModule = {
    registerSelf: function(compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(ACSEARCHPROXY_CID, 
                                        "scAutoCompleteSearchProxySvc JS component", 
                                        ACSEARCHPROXY_CONTRACTID, 
                                        fileSpec, 
                                        location,
                                        type);
    },

    getClassObject: function(compMgr, cid, iid) {
        if (!cid.equals(ACSEARCHPROXY_CID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return scAutoCompleteSearchProxySvcFactory;
    },

    canUnload: function(compMgr) { return true; }
};

/* Class Factory */
var scAutoCompleteSearchProxySvcFactory = {
    createInstance: function(outer, iid) {
        if (outer != null)
            throw Components.results.NS_ERROR_NO_AGGREGATION;
    
        if (!iid.equals(ACSEARCHPROXY_IID) &&
            !iid.equals(Components.interfaces.nsISupports))
            throw Components.results.NS_ERROR_INVALID_ARG;

        return new scAutoCompleteSearchProxy();
    }
}

/* Module initialisation */
function NSGetModule(comMgr, fileSpec) { return scModule; }

