#!/bin/bash

BACKUPDIR=/opt/iParapheur/backups
DATE=$1
DOCUMENTROOT=/opt/iParapheur
DBS="alfresco"
HOSTNAME=`hostname`
DIR=$BACKUPDIR/$DATE
RESTORESQL=$BACKUPDIR/$DATE/restore.sql
ROTATEDIR=$BACKUPDIR
HER=`pwd`

### test avant lancement du script
if [ "$1" = "" ]; then
        echo "**$0: Merci de spcifier la date de sauvegarde  restorer au format DD-MM-YYYY"
        exit 1
fi

if [ ! -d $DIR ]; then
        echo "**$0: Il n'y a aucune sauvegarde pour cette date : $DATE"
        exit 1
fi



if [ ! -d $DOCUMENTROOT ]; then
        echo "**$0: DocumentRoot invalide:$DOCUMENTROOT"
        exit 1
fi

# Create a good sql script
echo "DROP DATABASE \`alfresco\` ;"   >  $RESTORESQL
echo "CREATE DATABASE \`alfresco\` ;" >> $RESTORESQL 
echo "use \`alfresco\` ;"             >> $RESTORESQL            
cat  $DIR/alfresco.sql                >> $RESTORESQL

cd $DOCUMENTROOT
rm -rf alf_data
tar -xzf $DIR/parapheur.tar.gz alf_data

#restore database 
mysql -u root  < $RESTORESQL

clear
echo "La restauration s'est effectue correctement, merci de redmarrer le parapheur : "
