#!/bin/bash
#version 1.0
# Création du script
#version 1.1
# ajout d'un controle sur les fichiers telecharge via wget
# ajout d'un controle sur la variable MD5
#version 1.1
# ajout d'un c_rehash en fin de script


DIR=$1
cd $DIR

if [ -e $DIR/validca.tgz ]
then
	echo "Suppression de validca.tgz"
	rm $DIR/validca.tgz
fi

if [ -e /tmp/validca.md5sum ]
then
	echo "Suppression de validca.md5sum"
	rm /tmp/validca.md5sum
fi

/usr/bin/wget --no-proxy -q http://crl.adullact.org/validca.tgz

cd /tmp
/usr/bin/wget --no-proxy -q http://crl.adullact.org/validca.md5sum

if [ ! -e $DIR/validca.tgz ]
then
	echo "Le fichier $DIR/validca.tgz n'existe pas"
	exit;
fi

if [ ! -e /tmp/validca.md5sum ]
then
	echo "Le fichier /tmp/validca.md5sum n'existe pas"
        exit;
fi

MD5=`md5sum $DIR/validca.tgz | awk '{print $1}'`
echo $MD5

if [ -z $MD5 ]
then
	echo "PROBLEME MD5SUM null"
	exit;
fi

if [ $MD5 != `cat /tmp/validca.md5sum` ]
then
	echo "PROBLEME MD5SUM DIFFERENT DE CELUI TELECHARGE";
	exit;
fi

if [ -e $DIR/validca-old ]
then
	rm -r $DIR/validca-old
fi

if [ -e $DIR/validca ]
then
	mv $DIR/validca $DIR/validca-old
fi

cd $DIR
tar -xzf $DIR/validca.tgz
c_rehash $DIR/validca
