#!/bin/bash

BACKUPDIR=/opt/iParapheur/backups
DATE=`date +%d-%m-%Y`
DOCUMENTROOT=/opt/iParapheur
BINDIR=$DOCUMENTROOT/bin
DBS="alfresco"
HOSTNAME=`hostname`
DIR=$BACKUPDIR/$DATE
ROTATEDIR=$BACKUPDIR
HER=`pwd`

### test avant lancement du script
if [ ! -d $DOCUMENTROOT ]; then
        echo "**$0: DocumentRoot invalid:$DOCUMENTROOT"
        exit 1
fi

#create backup directory
if [ ! -d $DIR ]
then
        mkdir -p $DIR
fi
#save repository
cd $DOCUMENTROOT
tar -czf $DIR/parapheur.tar.gz alf_data

#save metadata
for b in $DBS
        do
                mysqldump --add-locks --add-drop-table -u"root" -pPASSWORD $b 1> $DIR/$b.sql  
        done
#save backup cmd
cd $HER
cp -a $0 $DIR

#rotate des archives
i=`ls -c1 $ROTATEDIR|wc -l`
NBR=4
cd $ROTATEDIR

if [ $i -gt $NBR ]; then

        while [ $i -ne $NBR ]; do
                rm -rf `ls -rt|head -1`
                i=`ls -c1 $ROTATEDIR|wc -l`
        done
fi
#Envoi de la sauvegarde sur le serveur ftp
#$BINDIR/send_backup.sh $DATE
