
import java.util.*;
import com.crystaldecisions.sdk.occa.infostore.*;
import com.crystaldecisions.sdk.plugin.desktop.program.IProgramBase;
import com.crystaldecisions.sdk.framework.IEnterpriseSession;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;


public class SynchADUsers implements IProgramBase {

	public void run(IEnterpriseSession iEnterpriseSession, IInfoStore iInfoStore, String[] string) throws SDKException {

		String txtLoggedIn = "";
		try {
                  System.out.println("\n [secWinAD] Log on was successful on BOE XI system:  " + iEnterpriseSession.getCMSName() + "    	" + new Date() + "\n\n");
                  txtLoggedIn = "true";
            	} catch (Exception error) {
                  txtLoggedIn = "false";
                  System.out.println("\nThe login was unsuccessful");
		}

		if (txtLoggedIn == "true") {

	////////////////////////////////////////////////////////////////////////
	//Update BOE XI R2 AD User Groups against the AD repository
	//
	////////////////////////////////////////////////////////////////////////

			IInfoObjects IInfoObjects_ADGrpRefresh;
			IInfoObject secWinADplugin;

			try {
			  IInfoObjects_ADGrpRefresh = iInfoStore.query("SELECT TOP 1* FROM CI_SYSTEMOBJECTS WHERE SI_NAME='secWinAD'");
			  secWinADplugin = (IInfoObject) IInfoObjects_ADGrpRefresh.get(0);
			  secWinADplugin.properties().getProperty(CePropertyID.SI_UPDATE_TS).setValue(new Date());
			  iInfoStore.commit(IInfoObjects_ADGrpRefresh);
			} catch (Exception error) {
			  System.out.println("There was an error querying the CMS: (" + error.getMessage() + ") for query: (SELECT TOP 1* FROM CI_SYSTEMOBJECTS WHERE SI_NAME='secWinAD'");
			  throw new Error("There was an error querying the CMS: (" + error.getMessage() + ") for query: (SELECT TOP 1* FROM CI_SYSTEMOBJECTS WHERE SI_NAME='secWinAD')");
			}
		}
	}
}

