package ParseurArborescence;

import org.xml.sax.*;
import org.xml.sax.helpers.*;


import javax.xml.parsers.*; 
import java.io.*; 
import java.util.Iterator;

public class parseur extends DefaultHandler{
   //rsultats de notre parsing
	private RepGroupe repGroupe;
   private Fichier fichier;
   private SousRep sousRep;
   
   //flags nous indiquant la position du parseur
   private boolean inRepGroupe=false;
   private boolean inSousRep=false;
   private boolean inFichier=false;
   
   // simple constructeur
   public parseur(){
      super();	
      
   }
   //dtection d'ouverture de balise
   public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException{
	   
      System.out.println(uri+" "+localName+" "+qName);
      
      if(qName.equals("RepGroupe"))
      { 
    	  repGroupe = new RepGroupe();
    	  try
    	  {
    		  int id_rep = Integer.parseInt(attributes.getValue("id_rep"));
    		  repGroupe.id_rep = id_rep;
    		  
    		  int rep_parent = Integer.parseInt(attributes.getValue("rep_parent"));
    		  repGroupe.rep_parent = rep_parent;
    		  
 	         String nom = attributes.getValue("nom");
	         repGroupe.nom=nom;
    		  
    		  int droits = Integer.parseInt(attributes.getValue("droits"));
    		  repGroupe.droits = droits;
    		  
    		  int proprietaire = Integer.parseInt(attributes.getValue("proprietaire"));
    		  repGroupe.proprietaire = proprietaire;
    		  
  	         String derniere_modif = attributes.getValue("derniere_modif");
	         repGroupe.derniere_modif=derniere_modif;
	         
    		 int id_groupe = Integer.parseInt(attributes.getValue("id_groupe"));
    		 repGroupe.id_groupe = id_groupe;
    		 
    	  }
    	  catch(Exception e)
    	  {
           	//erreur dans le contenu
              throw new SAXException(e);
    	  }
    	  inRepGroupe = true;
      }
      
      else if(qName.equals("Fichier"))
      {
    	  fichier = new Fichier();
         try{
	         	int id = Integer.parseInt(attributes.getValue("id_fic"));
	         	fichier.id_fic = id;
	         	
	         	String nom = attributes.getValue("nom");
	         	fichier.nom=nom;
	         	
	         	String type = attributes.getValue("type");
	         	fichier.type=type;
	         	
	         	int rep_parent = Integer.parseInt(attributes.getValue("rep_parent"));
	         	fichier.rep_parent = rep_parent;
	         	
	         	int droits = Integer.parseInt(attributes.getValue("droits"));
	         	fichier.droits = droits;
	         	
	         	int id_proprietaire = Integer.parseInt(attributes.getValue("id_proprietaire"));
	         	fichier.id_proprietaire = id_proprietaire;
	         	
	         	float taille = Float.parseFloat(attributes.getValue("taille"));
	         	fichier.taille = taille;
	         	
	         	String date_creation = attributes.getValue("date_creation");
	         	fichier.date_creation=date_creation;
	         	
	         	
	         	String derniere_modif = attributes.getValue("derniere_modif");
	         	fichier.derniere_modif=derniere_modif;
	         	
	         	try
	         	{
			         	 if(fichier.rep_parent==this.repGroupe.id_rep)
			        		 this.repGroupe.ajouterFichier(this.fichier);
			         	 
			        	 else //chercher le sous rep et inserer le fichier
			        	 {
			        		 this.repGroupe = RepGroupe.ajouterFichier(this.repGroupe, this.fichier.rep_parent, this.fichier);
			        		 //ajouterSousRep(this.repGroupe,this.sousRep.idRepParent,this.sousRep);
			        	 }
	         	}
	         	catch(Exception e)
	         	{
	         		System.out.println("Erreur lors de l'insertion du fichier");
	         	}
	         	
         	}
         
         catch(Exception e){
         	//erreur dans le contenu
            throw new SAXException(e);
         }
         
         inFichier = true;	
      }
      
      else if(qName.equals("SousRep"))
      {
    	  inSousRep = true;	
    	  
    	  sousRep = new SousRep();
    	  try
    	  {
    		  int idRep = Integer.parseInt(attributes.getValue("idRep"));
    		  sousRep.idRep = idRep;
    		  
    		  int idRepParent = Integer.parseInt(attributes.getValue("idRepParent"));
    		  sousRep.idRepParent = idRepParent;
    		  
    		  int idProprietaire = Integer.parseInt(attributes.getValue("idProprietaire"));
    		  sousRep.idProprietaire = idProprietaire;
    		  
 	         String nom = attributes.getValue("nom");
 	        sousRep.nom=nom;
 	        
 	         String derniereModif = attributes.getValue("derniereModif");
 	  	       sousRep.derniereModif=derniereModif;
    		  
    		  int droits = Integer.parseInt(attributes.getValue("droits"));
    		  sousRep.droits = droits;
	         
    		 int id_groupe = Integer.parseInt(attributes.getValue("id_groupe"));
    		 sousRep.id_groupe = id_groupe;
	    		try
	    		{
		    		 if(this.sousRep.idRepParent==this.repGroupe.id_rep)
		        		 this.repGroupe.listeRep.add((this.sousRep));
		        	 else //chercher le sous rep et inserer le sousRep
		        	 {
		        		 this.repGroupe = RepGroupe.ajouterSousRep(this.repGroupe,this.sousRep.idRepParent,this.sousRep);
		        	 }
	    		}
	    		catch (Exception e)
	    		{
	    			System.out.println("Erreur lors de l'insertion du rpertoire");
	    		}
    		 
    	  }
    	  catch(Exception e)
    	  {
           	//erreur dans le contenu
              throw new SAXException(e);
    	  }
    	  
      }
     
      else{
         //erreur, on peut lever une exception
         throw new SAXException("Balise "+qName+" inconnue.");	
      }
   }
   

   
   //dtection fin de balise
   public void endElement(String uri,String localName, String qName) throws SAXException{
      
	   if(qName.equals("SousRep")){
       
		   inSousRep = false;
      }
      
      else if(qName.equals("Fichier")){
    	 
    	
         inFichier = false;	
         
      }
      
      else if(qName.equals("RepGroupe")){
         inRepGroupe = false;
         //fin du traitement
      }
      
      else{
         //erreur, on peut lever une exception
         throw new SAXException("Balise "+qName+" inconnue.");	
      }          	
   }
   
   
   //dbut du parsing
   public void startDocument() throws SAXException {
   	  System.out.println("Dbut du parsing");
   }
   
   //fin du parsing
   public void endDocument() throws SAXException {
   	  System.out.println("Fin du parsing");
   	  System.out.println("Resultats du parsing");
   	  
   	  //Affichage du rsultat
   	  System.out.println(this.repGroupe.toString());
   	  
   }
   
   // test
   public static void main(String[] args){
      try{
         // cration d'une fabrique de parseurs SAX
         SAXParserFactory fabrique = SAXParserFactory.newInstance();
			
         // cration d'un parseur SAX
         SAXParser parseur = fabrique.newSAXParser();
			
         // lecture d'un fichier XML avec un DefaultHandler
         File fichier = new File("./test2.xml");
         DefaultHandler gestionnaire = new parseur();
         parseur.parse(fichier, gestionnaire);
		
      }catch(ParserConfigurationException pce)
      {
         System.out.println("Erreur de configuration du parseur");
         System.out.println("Lors de l'appel  SAXParser.newSAXParser()");
      }
      catch(SAXException se)
      {
         System.out.println("Erreur de parsing");
         System.out.println("Lors de l'appel  parse()");
         se.printStackTrace();
      }
      catch(IOException ioe)
      {
         System.out.println("Erreur d'entre/sortie");
         System.out.println("Lors de l'appel  parse()");
      }

   }	
}