/*
Copyright (C) 2007  Sverre Kristian Valskraa


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package org.easyFS;

public class EasyFSPathDecoder {

	private String[] spath;
	private String path;
	
	public EasyFSPathDecoder(String path) {
		this.path = path;
		if (isDirectory())
		{
			path = path.substring(7);
			if (path.startsWith("/"))
				path = path.substring(1);
			if (path.endsWith("/"))
				path = path.substring(0, path.length()-1);
			
			spath = path.split("/");
		}
	
	}
	
	public boolean isDirectory()
	{
		return path.startsWith("/");
	}
	
	public String getDirectory()
	{
		if (hasDirectory())
			return spath[0];
		else
			return null;
	}
	
	public boolean hasFile()
	{
		return spath != null && spath.length == 2;
	}
	public boolean hasDirectory()
	{
		return spath != null && spath.length > 0 && spath[0].length() >0;
	}
	
	public String getPhoto()
	{
		if (hasFile())
			return spath[1];
		else
			return null;
	}
	
}
