/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs;

import fuse.FuseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipEntryDataReader {
    private static final Log log = LogFactory.getLog(ZipEntryDataReader.class);
    private static final int bufferSize = 8192;
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private BufferedInputStream zipStream;
    private long zipPos;
    private long zipMarkPos;

    public ZipEntryDataReader(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public synchronized void read(ByteBuffer byteBuffer, long l) throws FuseException {
        int n;
        BufferedInputStream bufferedInputStream = this.getZipStream(l, byteBuffer.capacity());
        if (bufferedInputStream == null) {
            return;
        }
        byte[] byArray = new byte[byteBuffer.capacity()];
        try {
            n = bufferedInputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new FuseException("IO error", iOException).initErrno(5);
        }
        if (n > 0) {
            this.zipPos += (long)n;
            byteBuffer.put(byArray, 0, n);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("read " + byteBuffer.position() + "/" + byteBuffer.capacity() + " requested bytes"));
        }
    }

    private BufferedInputStream getZipStream(long l, int n) throws FuseException {
        try {
            while (true) {
                if (this.zipStream == null) {
                    this.zipStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipEntry), 8192);
                    this.zipPos = 0L;
                    this.zipStream.mark(8192);
                    this.zipMarkPos = 0L;
                }
                if (l == this.zipPos) {
                    this.zipStream.mark(8192);
                    this.zipMarkPos = this.zipPos;
                    return this.zipStream;
                }
                while (l > this.zipPos) {
                    this.zipStream.mark(8192);
                    this.zipMarkPos = this.zipPos;
                    long l2 = this.zipStream.skip(l - this.zipPos);
                    if (l2 == 0L) {
                        return null;
                    }
                    this.zipPos += l2;
                }
                if (l == this.zipPos) {
                    return this.zipStream;
                }
                if (l >= this.zipMarkPos) {
                    try {
                        this.zipStream.reset();
                        this.zipPos = this.zipMarkPos;
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.zipStream.close();
                this.zipStream = null;
            }
        }
        catch (IOException iOException) {
            throw new FuseException("IO error", iOException).initErrno(5);
        }
    }
}

