/*
 * Decompiled with CFR 0.152.
 */
package fuse;

import fuse.Filesystem3;
import fuse.FuseException;
import fuse.FuseFS;
import fuse.FuseFSDirFiller;
import fuse.FuseGetattrSetter;
import fuse.FuseOpenSetter;
import fuse.FuseSizeSetter;
import fuse.FuseStatfsSetter;
import fuse.XattrLister;
import fuse.XattrSupport;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Date;
import org.apache.commons.logging.Log;

public class Filesystem3ToFuseFSAdapter
implements FuseFS {
    private Filesystem3 fs3;
    private XattrSupport xattrSupport;
    private Charset cs;
    private Log log;

    public Filesystem3ToFuseFSAdapter(Filesystem3 filesystem3, Log log) {
        this(filesystem3, System.getProperty("file.encoding", "UTF-8"), log);
    }

    public Filesystem3ToFuseFSAdapter(Filesystem3 filesystem3, String string, Log log) {
        this(filesystem3, Charset.forName(string), log);
    }

    public Filesystem3ToFuseFSAdapter(Filesystem3 filesystem3, Charset charset, Log log) {
        this.fs3 = filesystem3;
        if (filesystem3 instanceof XattrSupport) {
            this.xattrSupport = (XattrSupport)((Object)filesystem3);
        }
        this.cs = charset;
        this.log = log;
    }

    @Override
    public int getattr(ByteBuffer byteBuffer, FuseGetattrSetter fuseGetattrSetter) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getattr: path=" + string));
        }
        try {
            return this.handleErrno(this.fs3.getattr(string, fuseGetattrSetter), fuseGetattrSetter);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int readlink(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("readlink: path=" + string));
        }
        CharBuffer charBuffer = CharBuffer.allocate(byteBuffer2.capacity());
        try {
            int n = this.fs3.readlink(string, charBuffer);
            if (n == 0) {
                charBuffer.flip();
                CharsetEncoder charsetEncoder = this.cs.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
                CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer2, true);
                if (coderResult.isOverflow()) {
                    throw new FuseException("Buffer owerflow while encoding result").initErrno(36);
                }
            }
            return this.handleErrno(n, charBuffer.rewind());
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int getdir(ByteBuffer byteBuffer, FuseFSDirFiller fuseFSDirFiller) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getdir: path=" + string));
        }
        try {
            fuseFSDirFiller.setCharset(this.cs);
            return this.handleErrno(this.fs3.getdir(string, fuseFSDirFiller), fuseFSDirFiller);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int mknod(ByteBuffer byteBuffer, int n, int n2) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("mknod: path=" + string + ", mode=" + Integer.toOctalString(n) + "(OCT), rdev=" + n2));
        }
        try {
            return this.handleErrno(this.fs3.mknod(string, n, n2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int mkdir(ByteBuffer byteBuffer, int n) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("mkdir: path=" + string + ", mode=" + Integer.toOctalString(n) + "(OCT)"));
        }
        try {
            return this.handleErrno(this.fs3.mkdir(string, n));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int unlink(ByteBuffer byteBuffer) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("unlink: path=" + string));
        }
        try {
            return this.handleErrno(this.fs3.unlink(string));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int rmdir(ByteBuffer byteBuffer) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("rmdir: path=" + string));
        }
        try {
            return this.handleErrno(this.fs3.rmdir(string));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int symlink(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("symlink: from=" + string + " to=" + string2));
        }
        try {
            return this.handleErrno(this.fs3.symlink(string, string2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int rename(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("rename: from=" + string + " to=" + string2));
        }
        try {
            return this.handleErrno(this.fs3.rename(string, string2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int link(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("link: from=" + string + " to=" + string2));
        }
        try {
            return this.handleErrno(this.fs3.link(string, string2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int chmod(ByteBuffer byteBuffer, int n) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("chmod: path=" + string + ", mode=" + Integer.toOctalString(n) + "(OCT)"));
        }
        try {
            return this.handleErrno(this.fs3.chmod(string, n));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int chown(ByteBuffer byteBuffer, int n, int n2) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("chown: path=" + string + ", uid=" + n + ", gid=" + n2));
        }
        try {
            return this.handleErrno(this.fs3.chown(string, n, n2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int truncate(ByteBuffer byteBuffer, long l) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("truncate: path=" + string + ", size=" + l));
        }
        try {
            return this.handleErrno(this.fs3.truncate(string, l));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int utime(ByteBuffer byteBuffer, int n, int n2) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("utime: path=" + string + ", atime=" + n + " (" + new Date((long)n * 1000L) + "), mtime=" + n2 + " (" + new Date((long)n2 * 1000L) + ")"));
        }
        try {
            return this.handleErrno(this.fs3.utime(string, n, n2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int statfs(FuseStatfsSetter fuseStatfsSetter) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)"statfs");
        }
        try {
            return this.handleErrno(this.fs3.statfs(fuseStatfsSetter), fuseStatfsSetter);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int open(ByteBuffer byteBuffer, int n, FuseOpenSetter fuseOpenSetter) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("open: path=" + string + ", flags=" + n));
        }
        try {
            return this.handleErrno(this.fs3.open(string, n, fuseOpenSetter), fuseOpenSetter);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer, Object object, ByteBuffer byteBuffer2, long l) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("read: path=" + string + ", fh=" + object + ", offset=" + l));
        }
        try {
            return this.handleErrno(this.fs3.read(string, object, byteBuffer2, l), byteBuffer2);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer, Object object, boolean bl, ByteBuffer byteBuffer2, long l) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("write: path=" + string + ", fh=" + object + ", isWritepage=" + bl + ", offset=" + l));
        }
        try {
            return this.handleErrno(this.fs3.write(string, object, bl, byteBuffer2, l), byteBuffer2);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int flush(ByteBuffer byteBuffer, Object object) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("flush: path=" + string + ", fh=" + object));
        }
        try {
            return this.handleErrno(this.fs3.flush(string, object));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int release(ByteBuffer byteBuffer, Object object, int n) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("release: path=" + string + ", fh=" + object + ", flags=" + n));
        }
        try {
            return this.handleErrno(this.fs3.release(string, object, n));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int fsync(ByteBuffer byteBuffer, Object object, boolean bl) {
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("fsync: path=" + string + ", fh=" + object + ", isDatasync=" + bl));
        }
        try {
            return this.handleErrno(this.fs3.fsync(this.cs.decode(byteBuffer).toString(), object, bl));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int getxattrsize(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, FuseSizeSetter fuseSizeSetter) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getxattrsize: path=" + string + ", name=" + string2));
        }
        try {
            return this.handleErrno(this.xattrSupport.getxattrsize(string, string2, fuseSizeSetter), fuseSizeSetter);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int getxattr(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getxattr: path=" + string + ", name=" + string2));
        }
        try {
            return this.handleErrno(this.xattrSupport.getxattr(string, string2, byteBuffer3), byteBuffer3);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int listxattrsize(ByteBuffer byteBuffer, FuseSizeSetter fuseSizeSetter) {
        int n;
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("listxattrsize: path=" + string));
        }
        XattrSizeLister xattrSizeLister = new XattrSizeLister();
        try {
            n = this.xattrSupport.listxattr(string, xattrSizeLister);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
        fuseSizeSetter.setSize(xattrSizeLister.size);
        return this.handleErrno(n, fuseSizeSetter);
    }

    @Override
    public int listxattr(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n;
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("listxattr: path=" + string));
        }
        XattrValueLister xattrValueLister = new XattrValueLister(byteBuffer2);
        try {
            n = this.xattrSupport.listxattr(string, xattrValueLister);
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
        if (xattrValueLister.boe != null) {
            return this.handleException(xattrValueLister.boe);
        }
        return this.handleErrno(n, xattrValueLister);
    }

    @Override
    public int setxattr(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("setxattr: path=" + string + ", name=" + string2 + ", value=" + byteBuffer3 + ", flags=" + n));
        }
        try {
            return this.handleErrno(this.xattrSupport.setxattr(string, string2, byteBuffer3, n));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    @Override
    public int removexattr(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String string = this.cs.decode(byteBuffer).toString();
        String string2 = this.cs.decode(byteBuffer2).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("removexattr: path= " + string + ", name=" + string2));
        }
        try {
            return this.handleErrno(this.xattrSupport.removexattr(string, string2));
        }
        catch (Exception exception) {
            return this.handleException(exception);
        }
    }

    private int handleErrno(int n) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)(n == 0 ? "  returning with success" : "  returning errno: " + n));
        }
        return n;
    }

    private int handleErrno(int n, Object object) {
        if (n != 0) {
            return this.handleErrno(n);
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("  returning: " + object));
        }
        return n;
    }

    private int handleErrno(int n, Object object, Object object2) {
        if (n != 0) {
            return this.handleErrno(n);
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("  returning: " + object + ", " + object2));
        }
        return n;
    }

    private int handleException(Exception exception) {
        int n;
        if (exception instanceof FuseException) {
            n = this.handleErrno(((FuseException)exception).getErrno());
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)exception);
            }
        } else if (exception instanceof BufferOverflowException) {
            n = this.handleErrno(34);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)exception);
            }
        } else {
            n = this.handleErrno(14);
            if (this.log != null) {
                this.log.error((Object)exception);
            }
        }
        return n;
    }

    private class XattrValueLister
    implements XattrLister {
        CharsetEncoder enc;
        ByteBuffer list;
        BufferOverflowException boe;

        XattrValueLister(ByteBuffer byteBuffer) {
            this.enc = Filesystem3ToFuseFSAdapter.this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.list = byteBuffer;
        }

        @Override
        public void add(String string) {
            if (this.boe == null) {
                try {
                    this.enc.encode(CharBuffer.wrap(string), this.list, true);
                    this.list.put((byte)0);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    this.boe = bufferOverflowException;
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            boolean bl = true;
            for (int i = 0; i < this.list.position(); ++i) {
                int n = i;
                int n2 = 0;
                while (n + n2 < this.list.position() && this.list.get(n + n2) != 0) {
                    ++n2;
                }
                byte[] byArray = new byte[n2];
                for (int j = 0; j < n2; ++j) {
                    byArray[j] = this.list.get(n + j);
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"').append(Filesystem3ToFuseFSAdapter.this.cs.decode(ByteBuffer.wrap(byArray))).append('\"');
                i = n + n2;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private class XattrSizeLister
    implements XattrLister {
        CharsetEncoder enc;
        int size;

        private XattrSizeLister() {
            this.enc = Filesystem3ToFuseFSAdapter.this.cs.newEncoder();
            this.size = 0;
        }

        @Override
        public void add(String string) {
            this.size += (int)((float)string.length() * this.enc.averageBytesPerChar()) + 1;
        }
    }
}

