package dialogue;

import java.io.*;
import java.net.*;
import java.util.Random;

public class HTTP_Requete {
	
	private URLConnection cx;
	private BufferedReader retour;
	private OutputStream header;
	private String bound;
	
	public HTTP_Requete(String url, Proxy proxy) {
		try {
			if(proxy != null) //si besoin du proxy
				cx = new URL(url).openConnection(proxy); //on ouvre la connexion}
			else	
				cx = new URL(url).openConnection();
			header = null;
			bound = "";
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}
	
	public void ajoutPOST(String[][] tabPost) throws IOException{
		if(!cx.getDoOutput()){
			cx.setDoOutput(true);
			initHeader();
		}
		for(int i=0;i<tabPost.length;i++){
			newline();
			write("Content-Disposition: form-data; name=\""+tabPost[i][0]+"\"");
		    newline();
		    newline();
		    writeln(tabPost[i][1]);
		    write("--" + bound);
		    	 
		}
	}
	
	public void ajoutFILE(String pathFile,String nomFile,String nomForm) throws IOException{
		if(!cx.getDoOutput()){
			cx.setDoOutput(true);
			initHeader();
		}		
		
		InputStream fic = new FileInputStream(pathFile);
		newline();
		write("Content-Disposition: form-data; name=\"");
	    write(nomForm);
	    write('"');
	    write("; filename=\"");
	    write(nomFile);
	    write('"');
	    newline();
	    write("Content-Type: ");
	    String type = URLConnection.guessContentTypeFromName(pathFile);
	    if (type == null) type = "application/octet-stream";
	    writeln(type);
	    newline();
	    pipe(fic, header); //recupere le contenu du fichier et l'envoi dans la requete
	    newline();
	    write("--" + bound);
	}
	
	public void ajoutFile(ByteArrayOutputStream fic, int idFile, String nomForm,String mime) throws IOException{		
		if(!cx.getDoOutput()){
			cx.setDoOutput(true);
			initHeader();
		}				
		newline();
		write("Content-Disposition: form-data; name=\"");
	    write(nomForm);
	    write('"');
	    write("; filename=\"");
	    write(""+idFile);
	    write('"');
	    newline();
	    write("Content-Type: ");
	    writeln(mime);
	    newline();
	    fic.writeTo(header);    
	    newline();
	    write("--" + bound);
		
	}
	
	// /!\ DOIT etre appel� avant ajoutPOST et ajoutFILE !! (sinon boum)
	public void ajoutCookie(String[][] tabCookies){
		if(!cx.getDoOutput()) {				
			String cookies = "";
			for(int i=0;i<tabCookies.length;i++){
				cookies += tabCookies[i][0] + "=" + tabCookies[i][1];
				if(i != tabCookies.length -1)
					cookies += "; ";
			}
			cx.setRequestProperty("Cookie", cookies); 
		}
		else 
			System.out.println("Impossible de rajouter des cookies � ce niveau l�, il faut le faire avant tout appel � ajoutFILE ou ajoutPOST");
	}
	
	public void envoi() throws IOException{
		if(cx.getDoOutput()){ //si il y a des arguments POST, on clot l'header
			writeln("--");
	    	header.close();
		}
	    retour = new BufferedReader(new InputStreamReader((cx.getInputStream()))); //on envoi la requete, et on recupere son resultat
	}
	
	public String reponse() throws IOException{
		String reponse  = "";
		String ligne;
		while ((ligne = retour.readLine()) != null) {
			reponse += ligne + "\n";
		}
		return reponse;
	}
	
	public void affichResult(){
		String ligne;
		try {
			while ((ligne = retour.readLine()) != null) {
				System.out.println(ligne);
				}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void recupFile(String pathFile) throws IOException{
		/*cr�ation du fichier d'arriv�e*/
		File destination = new File(pathFile);
		destination.createNewFile();

		/*cr�ation du flux d'�criture du fichier*/
		FileOutputStream destinationFile=null;		
        destinationFile = new FileOutputStream(destination);
        
        /*conversion inputStream g�n�r� par la requete en FileOutputStream*/
		pipe(cx.getInputStream(), destinationFile);
		
		/*�criture et fermeture du flux*/
        destinationFile.flush();
        destinationFile.close();
	}
	

	private void initHeader() throws IOException{
		cx.setDoOutput(true);		
		bound = boundary();		 
		cx.setRequestProperty("Content-Type","multipart/form-data; boundary=" + bound);
	    header = cx.getOutputStream();	    
	    write("--" + bound);
	}
	
	private static String boundary() {
		return "---------------------------" + Long.toString(new Random().nextLong(), 36);		
	}
	
	private void write(char c) throws IOException {
		 header.write(c);
	 }
	 
	 private void write(String s) throws IOException {
		   header.write(s.getBytes());
	 }

	 private void newline() throws IOException {
		   write("\r\n");
	}

	private void writeln(String s) throws IOException {
		   write(s);
		   newline();
	}
	
	
	private static void pipe(InputStream in, OutputStream out) throws IOException {
	    byte[] buf = new byte[500000];
	    int nread;
	    int total = 0;
	    synchronized (in) {
	      while((nread = in.read(buf, 0, buf.length)) >= 0) {
	        out.write(buf, 0, nread);
	        total += nread;
	      }
	    }
	    out.flush();
	    in.close();
	    buf = null;
	  }
}
