/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs;

import fuse.FuseMount;
import fuse.staticfs.DirectoryNode;
import fuse.staticfs.MountpointNode;
import fuse.staticfs.StaticFilesystem;
import fuse.zipfs.ZipFilesystem;
import java.io.File;
import java.io.IOException;

public class MultiZipFilesystem
extends StaticFilesystem {
    public MultiZipFilesystem(String[] stringArray, int n) throws IOException {
        super(new DirectoryNode("$ROOT"));
        DirectoryNode directoryNode = this.getRootNode();
        for (int i = n; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            directoryNode.addChild(new MountpointNode(file.getName(), new ZipFilesystem(file)));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: MultiZipFilesystem mountpoint zipfile1 [zipfile2 ...]");
            System.exit(-1);
        }
        String[] stringArray2 = new String[]{stringArray[0]};
        try {
            FuseMount.mount(stringArray2, new MultiZipFilesystem(stringArray, 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

