package divers;

import java.util.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class Mdate {

	private static DateFormat formatXML = new SimpleDateFormat("yyyy:MM:DD'T'HH:mm:ss");
	private static DateFormat formatHTML = new SimpleDateFormat("DD/MM/yy");
	private static DateFormat formatHTMLpetit = new SimpleDateFormat("HH:mm");
	
	public static String dateToXML(Date laDate){
		return formatXML.format(laDate);
	}
	
	public static Date xmlToDate(String laDate){
		try {
			return formatXML.parse(laDate);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static String dateToHTML(Date laDate){
		String aujourdhui = formatHTML.format(new Date());
		if(aujourdhui==formatHTML.format(laDate))//si le message date d'aujourd'hui
			return formatHTMLpetit.format(laDate); //on affiche juste l'heure
		else
			return formatHTML.format(laDate);	//sinon on affiche juste le jour	
	}
}

