/*
 * Decompiled with CFR 0.152.
 */
package fuse.staticfs;

import fuse.compat.FuseStat;
import fuse.staticfs.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DirectoryNode
extends Node {
    private Map children = new HashMap();

    public DirectoryNode(String string) {
        super(string);
    }

    @Override
    protected FuseStat createStat() {
        FuseStat fuseStat = new FuseStat();
        fuseStat.mode = 16877;
        fuseStat.gid = 0;
        fuseStat.uid = 0;
        fuseStat.mtime = fuseStat.atime = (int)(System.currentTimeMillis() / 1000L);
        fuseStat.ctime = fuseStat.atime;
        fuseStat.size = 0L;
        fuseStat.blocks = 0;
        return fuseStat;
    }

    public synchronized Node addChild(Node node) {
        Node node2 = this.children.put(node.getName(), node);
        node.setParent(this);
        FuseStat fuseStat = (FuseStat)this.getStat().clone();
        fuseStat.mtime = fuseStat.atime = (int)(System.currentTimeMillis() / 1000L);
        this.setStat(fuseStat);
        if (node2 != null) {
            node2.setParent(null);
        }
        return node2;
    }

    public synchronized Node removeChild(String string) {
        Node node = (Node)this.children.remove(string);
        if (node != null) {
            FuseStat fuseStat = (FuseStat)this.getStat().clone();
            fuseStat.mtime = fuseStat.atime = (int)(System.currentTimeMillis() / 1000L);
            this.setStat(fuseStat);
            node.setParent(null);
        }
        return node;
    }

    public synchronized Node getChild(String string) {
        return (Node)this.children.get(string);
    }

    public synchronized Node[] getChildren() {
        Collection collection = this.children.values();
        return collection.toArray(new Node[collection.size()]);
    }
}

