/*
 * Decompiled with CFR 0.152.
 */
package fuse.logging;

import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class FuseLog
implements Log {
    public static PrintStream trace = System.err;
    public static PrintStream debug = System.err;
    public static PrintStream info = System.err;
    public static PrintStream warn = System.err;
    public static PrintStream error = System.err;
    public static PrintStream fatal = System.err;
    public static final String LEVEL_PREFIX = "fuse.logging.level";
    private static final int LEVEL_TRACE = 0;
    private static final int LEVEL_DEBUG = 1;
    private static final int LEVEL_INFO = 2;
    private static final int LEVEL_WARN = 3;
    private static final int LEVEL_ERROR = 4;
    private static final int LEVEL_FATAL = 5;
    private static final String[] levelNames = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static final String formatPattern = "%1$tH:%1$tM:%1$tS.%1$tL %2$8s %3$5s [%4$s]: %5$s%n";
    private static final Levels levels = new Levels();
    private String name;

    public static void setOut(PrintStream printStream) {
        error = fatal = printStream;
        warn = fatal;
        info = fatal;
        debug = fatal;
        trace = fatal;
    }

    public FuseLog(String string) {
        this.name = string;
    }

    public boolean isDebugEnabled() {
        return levels.isDebugEnabled(this.name);
    }

    public boolean isErrorEnabled() {
        return levels.isErrorEnabled(this.name);
    }

    public boolean isFatalEnabled() {
        return levels.isFatalEnabled(this.name);
    }

    public boolean isInfoEnabled() {
        return levels.isInfoEnabled(this.name);
    }

    public boolean isTraceEnabled() {
        return levels.isTraceEnabled(this.name);
    }

    public boolean isWarnEnabled() {
        return levels.isWarnEnabled(this.name);
    }

    public void trace(Object object) {
        this._log(0, trace, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this._log(0, trace, object, throwable);
    }

    public void debug(Object object) {
        this._log(1, debug, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this._log(1, debug, object, throwable);
    }

    public void info(Object object) {
        this._log(2, info, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this._log(2, info, object, throwable);
    }

    public void warn(Object object) {
        this._log(3, warn, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this._log(3, warn, object, throwable);
    }

    public void error(Object object) {
        this._log(4, error, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this._log(4, error, object, throwable);
    }

    public void fatal(Object object) {
        this._log(5, fatal, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this._log(5, fatal, object, throwable);
    }

    private void _log(int n, PrintStream printStream, Object object, Throwable throwable) {
        if (n >= FuseLog.levels.getLevelValue(this.name)) {
            if (object instanceof Throwable && throwable == null) {
                throwable = (Throwable)object;
            }
            String string = object.toString();
            printStream.printf(formatPattern, new Date(), Thread.currentThread().getName(), levelNames[n], this.name, string);
            if (throwable != null) {
                throwable.printStackTrace(printStream);
            }
        }
    }

    private static class Levels {
        private Map name2levelMap = new HashMap();

        Levels() {
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith(FuseLog.LEVEL_PREFIX)) continue;
                String string2 = string.length() == FuseLog.LEVEL_PREFIX.length() ? "" : string.substring(FuseLog.LEVEL_PREFIX.length() + 1);
                String string3 = properties.getProperty(string);
                int n = -1;
                for (int i = 0; i < levelNames.length; ++i) {
                    if (!levelNames[i].equals(string3)) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    throw new IllegalArgumentException("Invalid logging level specified for System property: " + string + ": " + string3);
                }
                this.name2levelMap.put(string2, new Integer(n));
            }
        }

        boolean isDebugEnabled(String string) {
            return this.getLevelValue(string) <= 1;
        }

        boolean isErrorEnabled(String string) {
            return this.getLevelValue(string) <= 4;
        }

        boolean isFatalEnabled(String string) {
            return this.getLevelValue(string) <= 5;
        }

        boolean isInfoEnabled(String string) {
            return this.getLevelValue(string) <= 2;
        }

        boolean isTraceEnabled(String string) {
            return this.getLevelValue(string) <= 0;
        }

        boolean isWarnEnabled(String string) {
            return this.getLevelValue(string) <= 3;
        }

        public String toString(String string) {
            return levelNames[this.getLevelValue(string)];
        }

        private int getLevelValue(String string) {
            while (true) {
                Integer n;
                if ((n = (Integer)this.name2levelMap.get(string)) != null) {
                    return n;
                }
                if (string.length() == 0) break;
                int n2 = string.lastIndexOf(46);
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                    continue;
                }
                string = "";
            }
            return 2;
        }
    }
}

