/**
 *   EasyFSLogin: Graphical Intergace for EasyFS
 *
 *   Copyright (C) 2008
 *
 *   This program can be distributed under the terms of the GNU LGPL.
 *   
 */
package easyFS;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import org.omg.PortableServer.Servant;

import dialogue.Appel;
import donnees.Repertoire;
import fuse.FuseException;

public class EasyFSLogin extends JFrame implements ActionListener
{
	 // la zone de texte pour le nom de l'utilisateur
	 JTextField user;
	 
	 // la zone de texte pour la saisie du proxy
	 JTextField proxy;
	
	 // la zone de texte pour la saisie du serveur
	 JTextField serv;
	 
	 // la zone de texte pour la saisie du numro de port du proxy
	 JTextField port;
	 
	 // la zone de texte pour la saisie du point de montage
	 JTextField mntpoint;
	 
	 // la zone de texte pour la saisie du mot de passe
	 JPasswordField pass;
	
	 // bouton de confirmation
	 JButton login;
	
	 // label pour le statut de la connexion
	 JLabel lblstat;

	 boolean send;
	
	
	public EasyFSLogin(String dir, String password, String usr, String server, String pro, Integer addr) throws Exception
	{
	JPanel p = new JPanel();
	// Cration de l'IHM
	p.setLayout(new GridLayout(8,2,0,5));
	p.setBorder(BorderFactory.createTitledBorder("EasyFS Login"));
	p.setPreferredSize(new Dimension(500, 300));
	JLabel lblmntpnt = new JLabel("Point de montage: ");
	JLabel lbluser = new JLabel("Utilisateur: ");
	JLabel lblpass = new JLabel("Mot de passe: ");
	JLabel lblserv = new JLabel("Serveur: ");
	JLabel lblproxy = new JLabel("Proxy hote : ");
	JLabel lblproxyport = new JLabel("Proxy port : ");
	
	// On cre et initialise les divers champs
	user = new JTextField();
	if (usr!=null)
   	 user.setText(usr);
     
	pass = new JPasswordField();
	if (password!=null)
   	 pass.setText(password);
	
	mntpoint = new JTextField();
	if (dir!=null)
   	 mntpoint.setText(dir);
	
	
	mntpoint.addActionListener(this);
	
	serv = new JTextField();
	 if (server!=null)
    	 serv.setText(server);  
	 else
	     serv.setText("defaut");
	
	proxy = new JTextField();
	if (pro!=null)
   	 	proxy.setText(pro);    
	else
		proxy.setText("aucun");
	
	port = new JTextField();
	if (addr!=null)
	   	 port.setText(addr.toString());
	else
		port.setText("aucun");
	
	login = new JButton("Soumettre");
	login.addActionListener(this);
	
	JLabel space = new JLabel("");
	
	JLabel lblauth = new JLabel("Statut: ");
	lblstat = new JLabel("");
	
	// Ajout des composants dans le panel
	p.add(lblmntpnt);
	p.add(mntpoint);
	p.add(lbluser);
	p.add(user);
	p.add(lblpass);
	p.add(pass);
	p.add(lblserv);
	p.add(serv);
	p.add(lblproxy);
	p.add(proxy);
	p.add(lblproxyport);
	p.add(port);
	p.add(space);
	p.add(login);
	p.add(lblauth);
	p.add(lblstat);
	
	add(p);
	setTitle("EasyFS Login");
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	setVisible(true);
	setResizable(true);
	pack();
	}
	
	// Gestion des actions
	public void actionPerformed(ActionEvent e)
	{
		if(e.getSource() == login)
		{
			Integer addr = null;
			String error = "";
			Appel app = null;
			String server = null;
			this.send = false;
			// Gestion des erreurs
			if (serv.getText() == null || serv.getText().equals("")) {
				lblstat.setForeground(Color.RED);
				lblstat.setText("Indiquez le serveur"); 
				error += "Indiquez le serveur"; }
			if (proxy.getText().equals("") || (port.getText().equals("") && !proxy.getText().equals("")) || (proxy.getText().equals("") && !port.getText().equals(""))) {	 
					lblstat.setForeground(Color.RED); 
					lblstat.setText("Indiquez proxy ET numero de port");
					error += "\nIndiquez proxy ET numero de port";}
			if (user.getText()==null || user.getText().equals("")) {
						lblstat.setForeground(Color.RED);
						lblstat.setText("Indiquez nom utilisateur"); 
						error += "\nIndiquez nom utilisateur";}
			if (pass.getText()==null || pass.getText().equals("")) {
					lblstat.setForeground(Color.RED);
					lblstat.setText("Indiquez mot de passe"); 
					error += "\nIndiquez mot de passe";}
			if (mntpoint.getText()==null || mntpoint.getText().equals("")) {
					lblstat.setForeground(Color.RED);
					lblstat.setText("Indiquez point de montage"); 
					error += "\nIndiquez point de montage";}
			if (!port.getText().equals("aucun"))
			{
				 try {
					 addr = (new Integer(port.getText())).intValue();
				 }
			     catch (Exception e3) {
			    	 lblstat.setForeground(Color.RED);
			    	 lblstat.setText("Numero port proxy doit etre un entier");
			    	 error += "\nNumero port proxy doit etre un entier";
			    	 if (!error.equals(""))
			    	 JOptionPane.showMessageDialog(getParent(), error);
			     }
			}
			
					if (serv.getText().equals("defaut"))
						server="http://fuse.credi-ong.org/serveur/parse_requetes.php";
					else
						server=serv.getText();
	
					// Si le proxy est renseigne, on le traite
			    	if (!proxy.getText().equals("aucun") && !port.getText().equals("aucun")) {
			    		Proxy prox = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getText(), addr ));
						app = new Appel(prox,user.getText(),pass.getText(),server);
			    		}
			    	else
			    		app = new Appel(null,user.getText(),pass.getText(),server);
			    	
			    	// On gere l'erreur pour laquelle l'utilisateur ne renseigne qu'un des deux parametres
			    	if ((proxy.getText().equals("aucun") && !port.getText().equals("aucun")) || (!proxy.getText().equals("aucun") && port.getText().equals("aucun")))
			    		{lblstat.setForeground(Color.RED);
			    		lblstat.setText("Indiquez proxy ET numero de port"); 
			    		error += "\nIndiquez proxy ET numero de port";
			    		}
			    	
					try {
						Object retour = app.authentification();
						if (retour instanceof Repertoire && (lblstat.getText()==null || lblstat.getText().equals("") || error.equals(""))) {
							lblstat.setForeground(Color.GREEN);
							lblstat.setText("Access granted");
							this.send=true;
							// Tout s'est bien passe
							JOptionPane.showMessageDialog(getParent(), "Access granted!");
							dispose();
						}
						else 
						{
							lblstat.setForeground(Color.RED);
							if (!error.equals("")) {
								JOptionPane.showMessageDialog(getParent(), error);
								lblstat.setText("");
								error = "";
							}
							else if (!(retour instanceof Repertoire)) {
							lblstat.setText("Erreur connexion");
							JOptionPane.showMessageDialog(getParent(), "Nom utilisateur ou mot de passe incorrect!"); }
							this.send = false;
						}
					} catch (Exception e1) {
						// TODO Auto-generated catch block
						lblstat.setText("Erreur connexion");
						if (error.equals(""))
						JOptionPane.showMessageDialog(getParent(), "Erreur inconnue!");
						else
							JOptionPane.showMessageDialog(getParent(), error);
					}
			    
		
	    	}
		
		if (e.getSource() == mntpoint){
		  			JFileChooser chooser = new JFileChooser(this.mntpoint.getText());
		  			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		  		    chooser.setAcceptAllFileFilterUsed(false);
		  			chooser.showOpenDialog(getParent());
		  			try {
		  			
		  			if (!chooser.getSelectedFile().getAbsolutePath().equals(""))
		  				mntpoint.setText(chooser.getSelectedFile().getAbsolutePath());
		  				}
		  				catch (Exception e4){
		  					System.err.println("Selectionner un dossier valide!");
		  				}
		      }
		   
		
	}
}