package cache;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;


import constantes.Codes;


import dialogue.Appel;
import donnees.R;



public class Cache {

	private String chemin;
	private Appel apl;
	private List<structCache> listeCache = new ArrayList<structCache>();
	
	
	public Cache(Appel instanceAppel, String cheminCache)
	{
		 
		// Pour crer le rpertoire de cache
		File fb = new File(cheminCache);
		this.chemin=fb.getAbsolutePath();
		System.out.println("Chemin cache : "+chemin);
		if (!fb.exists())
			fb.mkdirs();

		this.apl=instanceAppel;
	}
	
    public int miseEnCache(int idFichier) throws IOException
    {
            int codeRetour = 0;
            structCache sc;
            String cheminFichierLocal = chemin+"/"+idFichier;//verifer le
            System.out.println("Mise en cache Fic :"+cheminFichierLocal);
            codeRetour = (Integer) apl.telechargerFichier(idFichier, cheminFichierLocal);
            if(  codeRetour==Codes.OK)
            {
                    sc = new structCache();
                    sc.idFichier=idFichier;
                    R r = apl.derniereMAJfichier(idFichier);
                    if(r.code == Codes.OK)
                    	sc.date=  r.s ;
                    else
                    	return Codes.EACCES;
                    this.listeCache.add(sc);
            }

            return codeRetour;
    }
    
    
    public byte[] getContent(int idFic, int size) throws IOException{
    	
	    String chemin = this.chemin+"/"+idFic;

	    	if(size > 0 && new File(chemin).exists()){
		    	byte[] buf = new byte[size];
		    	InputStream in = new FileInputStream(chemin);
		    	synchronized (in) {
		    		in.read(buf, 0, buf.length);  	
		    	return buf; 
		    	}
	    	}
	    	return new byte[0];
    }

    public String getMIMEType(java.io.File file){
       if(file.isDirectory()){return "repertoire";}
       if(!file.exists()){return "fichier inexistant";}
       try{
          URL url = file.toURL();
          URLConnection connection = url.openConnection();
          return connection.getContentType();
       }catch(MalformedURLException mue){
          return mue.getMessage();
       }catch(IOException ioe){
          return ioe.getMessage();
          }
    }

       public String getMime(Integer idFic) {
   	    String chemin = this.chemin+"/"+idFic.toString();
       	return getMIMEType(new File(chemin));
       }
    
	public boolean fichierDsCache(int idFichier)
	{
		for(structCache stc : this.listeCache)
		{
			if(stc.idFichier==idFichier){
			String chemin = this.chemin+"/"+idFichier;
			 return (new File(chemin).exists())  ? true : false;
			}
		}
		return false;
	}
	
	public boolean fichierAjour(int idFichier)
	{
		if(!fichierDsCache(idFichier)) return false;
		else
		{
			for(structCache stc : this.listeCache)
			{
				try {
					if(stc.idFichier==idFichier){
					R r = this.apl.derniereMAJfichier(idFichier);
					if (r.code == Codes.OK)
						return (stc.date.equals(r.s)) ;
					return false;
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					return false;
				}
			}
		}
		return false;
	}
	
	
	public int saveFile(int idFichier, String cheminFichierLocal){
		
		/* sauvegarde du fichier
		 * envoi du ficher au serveur
		 */
		
		//envoi du ficher au serveur
		
		if(fichierDsCache(idFichier))
		{
			
			//this.apl.modifierFichier(idFichier,cheminFichierLocal);
			return 1;
		}
		return 0;
	}
	
	public void clear() {
		this.listeCache.clear();
	}
	
	
}
