package parseurs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import donnees.Fichier;
import donnees.Repertoire;

public class ParseurArborescence extends DefaultHandler{
   //rsultats de notre parsing
   private Repertoire rep, rep_courant;
   private Fichier fichier;
   
   //parseur SAX
   private SAXParser parseur;
   
   
	public ParseurArborescence(){	
		super();
		// creation d'un parseur SAX
        try{
        	parseur = SAXParserFactory.newInstance().newSAXParser();			
        }
        catch(ParserConfigurationException pce)
        {
           System.out.println("Erreur de configuration du parseur");
        }
        catch (SAXException e) {
			System.out.println("Erreur Sax");
			e.printStackTrace();
		}      
	}
   
   public void Go(String PathFile){	
	   try {
		parseur.parse(new File(PathFile), this);
	} catch (SAXException e) {
		e.printStackTrace();
	} catch (IOException e) {
		e.printStackTrace();
	}
   }
	
   public void GoS(String arb){
   try{
       ByteArrayInputStream str = new ByteArrayInputStream(arb.getBytes());
		parseur.parse(str, this); 
		}
   catch(SAXException se){
       System.out.println("Erreur de parsing");
       System.out.println("Lors de l'appel a parse() (saxException)");
       se.printStackTrace();
    }
    catch(IOException ioe){
       System.out.println("Erreur d'entree/sortie");
       System.out.println("Lors de l'appel a parse() (ioException)");
    }
   }
   
   
   public Repertoire getObj(){
	   return rep;
   }
   
   
   //dtection d'ouverture de balise
   public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException{
      
      if(qName.equals("RepGroupe"))
      { 
    	  rep = new Repertoire();
    	  try
    	  {
    		  rep.idRep = Integer.parseInt(attributes.getValue("id_rep"));  		  
    		  rep.idRepParent = Integer.parseInt(attributes.getValue("rep_parent"));  		  
    		  rep.nom=attributes.getValue("nom"); 		  
    		  rep.droits = Integer.parseInt(attributes.getValue("droits"));  		  
    		  rep.idProprietaire =Integer.parseInt(attributes.getValue("proprietaire")); 		  
    		  rep.derniereModif=attributes.getValue("derniere_modif");         
    		  rep.id_groupe = Integer.parseInt(attributes.getValue("id_groupe")); 
    		  
    		  rep_courant = rep;
    	  }
    	  catch(Exception e)
    	  {
           	System.out.println("erreur dans le contenu");
             // throw new SAXException(e);
    	  }   	  
      }
      
      else if(qName.equals("Fichier"))
      {
    	  fichier = new Fichier();
	         	fichier.id_fic = Integer.parseInt(attributes.getValue("id_fic"));        	
	         	fichier.nom=attributes.getValue("nom");	         	
	         	fichier.type=attributes.getValue("type");	         	
	         	fichier.rep_parent = Integer.parseInt(attributes.getValue("rep_parent"));	         	
	         	fichier.droits = Integer.parseInt(attributes.getValue("droits"));	         	
	         	fichier.id_proprietaire = Integer.parseInt(attributes.getValue("id_proprietaire"));	         	
	         	fichier.taille = Integer.parseInt(attributes.getValue("taille"));         	
	         	fichier.date_creation=attributes.getValue("date_creation");	         		         	
	         	fichier.derniere_modif=attributes.getValue("derniere_modif");
	         	
	         	try
	         	{
			       if(fichier.rep_parent==rep_courant.idRep)
			    	   rep_courant.ajouterFichier(this.fichier);		         	 
			       else //chercher le sous rep et inserer le fichier
			          System.out.println("Erreur dans le xml, un fichier pas ?? sa place !");
	         	}
	         	catch(Exception e)
	         	{
	         		System.out.println("Erreur lors de l'insertion du fichier");
	         	}	    
      }
      
      else if(qName.equals("SousRep"))
      {
    	  Repertoire unrep = new Repertoire();
    	  try
    	  {
    		  unrep.idRep = Integer.parseInt(attributes.getValue("idRep")); 
    		  unrep.idRepParent = Integer.parseInt(attributes.getValue("idRepParent"));  		  
    		  unrep.nom=attributes.getValue("nom"); 		  
    		  unrep.droits = Integer.parseInt(attributes.getValue("droits"));  		  
    		  unrep.idProprietaire =Integer.parseInt(attributes.getValue("idProprietaire")); 		  
    		  unrep.derniereModif=attributes.getValue("derniereModif");         
    		  unrep.id_groupe = Integer.parseInt(attributes.getValue("id_groupe"));    
    		
    		  
    		while(rep_courant.idRep != unrep.idRepParent) //tant qu'on est pas retourn?? au bon repertoire parent, on remonte dans l'arborescence
    			rep_courant = rep_courant.parent();
    			
    		unrep.repParent = rep_courant;
	    	rep_courant.ajouterSousRep(unrep);
	    	rep_courant = unrep;		 
    	  }
    	  catch(Exception e)
    	  {
    		  System.out.println("Erreur lors de l'insertion du sous-repertoire ["+unrep.idRep+"/"+unrep.idRepParent+"]");
           	//erreur dans le contenu
              throw new SAXException(e);
    	  }
      }    
      else{
         //erreur, on peut lever une exception
         throw new SAXException("Balise "+qName+" inconnue.");	
      }
   }

}