package dialogue;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.util.logging.FileHandler;


import constantes.Codes;
import divers.Md5;
import donnees.AttrD;
import donnees.AttrF;
import donnees.Quota;
import donnees.Reponse;
import parseurs.ParseurRequete;
import parseurs.ParseurArborescence;
import donnees.R;

public class Appel {

	private Proxy proxy;
	private String login;
	private String md5Password;
	private String url;
	private ParseurRequete parseurRep;
	private ParseurArborescence parseurArb;
	private String idSession = null;
	private String dateMAJ;
//	private String pathXMLtmp = "./arbo.xml";
	
	public Appel(Proxy proxy, String login, String password,String urlRequete) {
		this.proxy = proxy;
		this.login = login;
		this.md5Password = Md5.encode(password);
		this.url = urlRequete;
		parseurRep = new ParseurRequete();
		parseurArb = new ParseurArborescence();
		idSession = null;
	}
	
	/* ------------------ REQUETES GENERALES --------------------*/
	
	
	public Object authentification() throws IOException {
		String requete ="<requete action=\"authentification\">" +  
        				"	<param name=\"login\" value=\""+login+"\" />" +  
        				"   <param name=\"password\" value=\""+md5Password+"\" />" +
        				"</requete>";	

		Reponse rep = parseReponse(envoiRequete(requete),2);
		if(rep.getCode()== Codes.OK){
			idSession = rep.get("id_session");		
			
			//parsage de l'arborescence
	        parseurArb.GoS(recupArb(rep.get("url_xml")));      
	        return (donnees.Repertoire)  parseurArb.getObj();
		}
		else
			return (Integer) rep.getCode();
	}
	
	public boolean besoinMAJ() throws IOException {
		String requete = "<requete action=\"date\" />";

		Reponse rep = parseReponse(envoiRequete(requete),1);
		if(rep.getCode()== Codes.OK){
			if(rep.get("date").equals(dateMAJ))
				return false;
			dateMAJ = rep.get("date");
		}
		return true;
	}
	
	public Object demanderArb() throws IOException {
		String requete = "<requete action=\"arborescence\" />";
		Reponse rep = parseReponse(envoiRequete(requete),1);
		if(rep.getCode()== Codes.OK){
			parseurArb.GoS(recupArb(rep.get("url_xml")));     
	        return (donnees.Repertoire)  parseurArb.getObj();
		}			
		else
			return (Integer) rep.getCode();
	}
	
	public Object getQuota() throws IOException {
		String requete = "<requete action=\"quota\" />";
		Reponse rep = parseReponse(envoiRequete(requete),2);
		if(rep.getCode()== Codes.OK){
			return new Quota(Integer.parseInt(rep.get("taille")),Integer.parseInt(rep.get("taille_max")));
		}
		return rep.getCode();				
	}
	
	/* --------------- REQUETES SUR LES FICHIERS ------------------*/
	
	public R touchFile(String nomFic, int idRepParent,int droits) throws IOException  {
			String requete = "<requete action=\"touch\">"+	
			 				 "	<param name=\"nom_fichier\" value=\""+nomFic+"\" />" +  
			 				 "	<param name=\"id_rep_parent\" value=\""+idRepParent+"\" />" +
			 				 "  <param name=\"droits\" value=\""+droits+"\" /> "+
			 				 "</requete>";
			/*System.out.println((envoiRequete(requete)));
			return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),2);
		int id_fic = (rep.getCode() == Codes.OK) ? Integer.parseInt(rep.get("id")) : 0;
		String date = (rep.getCode() == Codes.OK) ? rep.get("date") : "" ;
		return new R(rep.getCode(),id_fic,date);		
	}
	
	public int upContenu(int idFic, ByteArrayOutputStream buf, String mime) throws IOException {
		
		int q = modifierFichier(idFic);
		if (q==Codes.OK){
		System.out.println(envoiFile(idFic,buf,mime));
		return 0;
		/*Reponse rep = parseReponse(envoiFile(idFic,buf,mime),0);
		return (Integer) rep.getCode();*/
		}
		else
			return q;
	}
	
	public int chmodF(int idFic, int droits) throws IOException {
		String requete = "<requete action=\"chmodF\">" + 
						 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" + 
						 "	<param name=\"droits\" value=\""+droits+"\" />" + 
						 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);

		return (Integer) rep.getCode();
	}
	
	public Object getAttrF(int idFic) throws IOException {
		String requete = "<requete action=\"infoF\">" + 
		 				 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
		 				 "</requete>";
		/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),4);
		if(rep.getCode()==Codes.OK)
			return new AttrF(Integer.parseInt(rep.get("droits")),Integer.parseInt(rep.get("taille")),Integer.parseInt(rep.get("date_creation")),Integer.parseInt(rep.get("derniere_modif")));
		return (Integer) rep.getCode();
	}
	
	
	public int supprimerFichier(int idFic) throws IOException {
		String requete = "<requete action=\"supprimer_fichier\">" + 
	    				 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
	    				 "</requete>";
		/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return (Integer) rep.getCode(); //si OK => supprimer le fichier en local
	}
	
	public int modifierFichier(int idFic) throws IOException {
		String requete = "<requete action=\"modifier_fichier\">" + 
	    				 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
	    				 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);
		return (Integer) rep.getCode();
	}
	
	public Object deplacerFichier(int idFic,int idNouveauRep) throws IOException {
		String requete = "<requete action=\"deplacer_fichier\">" + 
	    				 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
	    				 "	<param name=\"id_nouvel_emplacement\" value=\""+idNouveauRep+"\" />" +
	    				 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return (Integer) rep.getCode(); //pas de parametres
	}
	
	public Object renommerFichier(int idFic,String nouveauNom) throws IOException {
		String requete = "<requete action=\"renommer_fichier\">" + 
	    				 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
	    				 "	<param name=\"nouveau_nom\" value=\""+nouveauNom+"\" />" +
	    				 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return (Integer) rep.getCode(); //pas de parametres
	}
	
	
	public Object telechargerFichier(int idFic,String pathLocal) throws IOException {
		String requete = "<requete action=\"telecharger_fichier\">" + 
						 "	<param name=\"id_fichier\" value=\""+idFic+"\" />" +  
						 "</requete>";
	/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),1);
		if(rep.getCode()== Codes.OK){
			recupFile(rep.get("url_download"), pathLocal);
			return Codes.OK; //on renvoi un petit OK pour dire que tout va bien
		}
		else return rep.getCode();
	}
	
	public void envoyerFichier(String urlUpload, String pathLocal,String nomFichier){
		envoiFile(urlUpload,pathLocal,nomFichier);
	}

	public R derniereMAJfichier(int idFic) throws IOException {
		
		String requete = "<requete action=\"derniereMAJfichier\">"+
							"	<param name=\"id_fic\" value=\""+idFic+"\" />"+
						 "</requete>";
	/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),1);
		String s = (rep.getCode() == Codes.OK) ? (rep.get("date_maj")) : "";
		
		return new R(rep.getCode(),0,s);
	}

	/* ----------------- REQUETES SUR LES REPERTOIRES ------------------*/
	

	public R creerRepertoire(String nomRep,int idEmplacement, int droits) throws IOException {
		String requete = "<requete action=\"creer_rep\">" + 
	    				 "	<param name=\"nom_rep\" value=\""+nomRep+"\" />" +  
	    				 "	<param name=\"emplacement\" value=\""+idEmplacement+"\" />" +
	    				 "  <param name=\"droits\" value=\""+droits+"\" /> "+
	    				 "</requete>";
		//System.out.println(requete);
/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
	Reponse rep = parseReponse(envoiRequete(requete),2);
	int id_rep = (rep.getCode() == Codes.OK) ? Integer.parseInt(rep.get("id")) : 0;
				
	return new R(rep.getCode(),id_rep,rep.get("date"));	
	}	
	
	public int chmodD(int idRep, int droits) throws IOException {
		String requete = "<requete action=\"chmodD\">" + 
						 "	<param name=\"id_rep\" value=\""+idRep+"\" />" + 
						 "	<param name=\"droits\" value=\""+droits+"\" />" + 
						 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);

		return (Integer) rep.getCode();
	}
	
	public Object getAttrD(int idRep) throws IOException {
		String requete = "<requete action=\"infoD\">" + 
		 				 "	<param name=\"id_rep\" value=\""+idRep+"\" />" +  
		 				 "</requete>";
		/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),2);
		if(rep.getCode()==Codes.OK)
			return new AttrD(Integer.parseInt(rep.get("droits")),Integer.parseInt(rep.get("derniere_modif")));
		return (Integer) rep.getCode();
	}
	
	public int supprimerRepertoire(int idRep) throws IOException {
		String requete = "<requete action=\"supprimer_rep\">" + 
	    				 "	<param name=\"id_rep\" value=\""+idRep+"\" />" +
	    				 "</requete>";
		/*System.out.println("coucou"+envoiRequete(requete)+"coucou");
		return null;*/
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return rep.getCode();
	}
	
	public Object renommerRepertoire(int idRep,String nouveauNom) throws IOException {
		String requete = "<requete action=\"renommer_rep\">" + 
	    				 "	<param name=\"id_rep\" value=\""+idRep+"\" />" +  
	    				 "	<param name=\"nouveau_nom\" value=\""+nouveauNom+"\" />" +
	    				 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return (Integer) rep.getCode();
	}	 
	
	
	public Object deplacerRepertoire(int idRep,int idNouvelEmplacement) throws IOException {
		String requete = "<requete action=\"deplacer_rep\">" + 
	    				 "	<param name=\"id_rep\" value=\""+idRep+"\" />" +  
	    				 "	<param name=\"nouveau_parent\" value=\""+idNouvelEmplacement+"\" />" +
	    				 "</requete>";
		Reponse rep = parseReponse(envoiRequete(requete),0);
		
		return (Integer) rep.getCode();
	}	
	
	
	/* ---------------- METHODES PRIVEES --------------------*/
	
	private String envoiRequete(String requete) throws IOException{
		String[][] post = new String[1][2];
		post[0][0] = "batman";
		post[0][1] = requete;		
		HTTP_Requete req = new HTTP_Requete(url,proxy);
		
		//Ajout du cookie contenant l'id de la session
		if(idSession != null){
			String[][] cookie = new String[1][2];
			cookie[0][0] = "PHPSESSID";
			cookie[0][1] = idSession;
			req.ajoutCookie(cookie);
		}
		req.ajoutPOST(post);
		req.envoi();
		return req.reponse();
	}	

	private void envoiFile(String urlUpload,String pathLocal,String nomFichier){
		String[][] cookie = new String[1][2];
		cookie[0][0] = "PHPSESSID";
		cookie[0][1] = idSession;
		
		HTTP_Requete req = new HTTP_Requete(urlUpload,proxy);
		req.ajoutCookie(cookie);
		try {
			req.ajoutFILE(pathLocal, nomFichier, "upFile");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private String envoiFile(int idFic, ByteArrayOutputStream buf,String mime) throws IOException{
		String[][] cookie = new String[1][2];
		cookie[0][0] = "PHPSESSID";
		cookie[0][1] = idSession;
		
		String[][] post = new String[1][2];
		post[0][0] = "id_file";
		post[0][1] = ""+idFic;
		
		HTTP_Requete req = new HTTP_Requete("http://fuse.credi-ong.org/serveur/up.php",proxy);
		req.ajoutCookie(cookie);
		req.ajoutPOST(post);
		req.ajoutFile(buf, idFic, "upFile",mime);
		req.envoi();
		
		return req.reponse();	
	}
	
	private void recupFile(String urlFile,String pathLocal){
		String[][] cookie = new String[1][2];
		cookie[0][0] = "PHPSESSID";
		cookie[0][1] = idSession;
		
		HTTP_Requete req = new HTTP_Requete(urlFile,proxy);
		req.ajoutCookie(cookie);
		try {
			req.recupFile(pathLocal);
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}
	
	private String recupArb(String urlArb) throws IOException{
		String[][] cookie = new String[1][2];
		cookie[0][0] = "PHPSESSID";
		cookie[0][1] = idSession;
		
		HTTP_Requete req = new HTTP_Requete(urlArb,proxy);
		req.ajoutCookie(cookie);
		req.envoi();
		return req.reponse();
	}
	
	private Reponse parseReponse(String retourRequete, int nbParam) throws IOException{
		return parseurRep.go(retourRequete, nbParam);
	}
		
}
