/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs;

import fuse.FuseException;
import fuse.FuseMount;
import fuse.FuseStatfs;
import fuse.compat.Filesystem1;
import fuse.compat.FuseDirEnt;
import fuse.compat.FuseStat;
import fuse.zipfs.ZipEntryDataReader;
import fuse.zipfs.ZipFileDataReader;
import fuse.zipfs.util.Node;
import fuse.zipfs.util.Tree;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipFilesystem
implements Filesystem1 {
    private static final Log log = LogFactory.getLog(ZipFilesystem.class);
    private static final int blockSize = 512;
    private ZipFile zipFile;
    private long zipFileTime;
    private ZipEntry rootEntry;
    private Tree tree;
    private FuseStatfs statfs;
    private ZipFileDataReader zipFileDataReader;

    public ZipFilesystem(File file) throws IOException {
        log.info((Object)"extracting zip file structure...");
        this.zipFile = new ZipFile(file, 1);
        this.zipFileTime = file.lastModified();
        this.rootEntry = new ZipEntry(""){

            @Override
            public boolean isDirectory() {
                return true;
            }
        };
        this.rootEntry.setTime(this.zipFileTime);
        this.rootEntry.setSize(0L);
        this.zipFileDataReader = new ZipFileDataReader(this.zipFile);
        this.tree = new Tree();
        this.tree.addNode(this.rootEntry.getName(), this.rootEntry);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.tree.addNode(zipEntry.getName(), zipEntry);
            if (zipEntry.isDirectory()) {
                ++n2;
            } else {
                ++n;
            }
            n3 = (int)((long)n3 + (zipEntry.getSize() + 512L - 1L) / 512L);
        }
        this.statfs = new FuseStatfs();
        this.statfs.blocks = n3;
        this.statfs.blockSize = 512;
        this.statfs.blocksFree = 0;
        this.statfs.files = n + n2;
        this.statfs.filesFree = 0;
        this.statfs.namelen = 2048;
        log.info((Object)("zip file structure extracted: " + n + " files, " + n2 + " directories, " + n3 + " blocks (" + 512 + " byte/block)."));
    }

    @Override
    public void chmod(String string, int n) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void chown(String string, int n, int n2) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public FuseStat getattr(String string) throws FuseException {
        Node node = this.tree.lookupNode(string);
        ZipEntry zipEntry = null;
        if (node == null || (zipEntry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        FuseStat fuseStat = new FuseStat();
        fuseStat.mode = zipEntry.isDirectory() ? 16877 : 33188;
        fuseStat.nlink = 1;
        fuseStat.uid = 0;
        fuseStat.gid = 0;
        fuseStat.size = zipEntry.getSize();
        fuseStat.mtime = fuseStat.ctime = (int)(zipEntry.getTime() / 1000L);
        fuseStat.atime = fuseStat.ctime;
        fuseStat.blocks = (int)((fuseStat.size + 511L) / 512L);
        return fuseStat;
    }

    @Override
    public FuseDirEnt[] getdir(String string) throws FuseException {
        Node node = this.tree.lookupNode(string);
        ZipEntry zipEntry = null;
        if (node == null || (zipEntry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (!zipEntry.isDirectory()) {
            throw new FuseException("Not A Directory").initErrno(20);
        }
        Collection collection = node.getChildren();
        FuseDirEnt[] fuseDirEntArray = new FuseDirEnt[collection.size()];
        int n = 0;
        for (Node node2 : collection) {
            FuseDirEnt fuseDirEnt;
            ZipEntry zipEntry2 = (ZipEntry)node2.getValue();
            fuseDirEntArray[n] = fuseDirEnt = new FuseDirEnt();
            fuseDirEnt.name = node2.getName();
            fuseDirEnt.mode = zipEntry2.isDirectory() ? 16384 : 32768;
            ++n;
        }
        return fuseDirEntArray;
    }

    @Override
    public void link(String string, String string2) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void mkdir(String string, int n) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void mknod(String string, int n, int n2) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void open(String string, int n) throws FuseException {
        ZipEntry zipEntry = this.getFileZipEntry(string);
        if (n == 1 || n == 2) {
            throw new FuseException("Read Only").initErrno(13);
        }
    }

    @Override
    public void rename(String string, String string2) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void rmdir(String string) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public FuseStatfs statfs() throws FuseException {
        return this.statfs;
    }

    @Override
    public void symlink(String string, String string2) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void truncate(String string, long l) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void unlink(String string) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    @Override
    public void utime(String string, int n, int n2) throws FuseException {
    }

    @Override
    public String readlink(String string) throws FuseException {
        throw new FuseException("Not a link").initErrno(2);
    }

    @Override
    public void write(String string, ByteBuffer byteBuffer, long l) throws FuseException {
    }

    @Override
    public void read(String string, ByteBuffer byteBuffer, long l) throws FuseException {
        ZipEntry zipEntry = this.getFileZipEntry(string);
        ZipEntryDataReader zipEntryDataReader = this.zipFileDataReader.getZipEntryDataReader(zipEntry, l, byteBuffer.capacity());
        zipEntryDataReader.read(byteBuffer, l);
    }

    @Override
    public void release(String string, int n) throws FuseException {
        ZipEntry zipEntry = this.getFileZipEntry(string);
        this.zipFileDataReader.releaseZipEntryDataReader(zipEntry);
    }

    private ZipEntry getFileZipEntry(String string) throws FuseException {
        ZipEntry zipEntry;
        Node node = this.tree.lookupNode(string);
        if (node == null || (zipEntry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (zipEntry.isDirectory()) {
            throw new FuseException("Not A File").initErrno(2);
        }
        return zipEntry;
    }

    private ZipEntry getDirectoryZipEntry(String string) throws FuseException {
        ZipEntry zipEntry;
        Node node = this.tree.lookupNode(string);
        if (node == null || (zipEntry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (!zipEntry.isDirectory()) {
            throw new FuseException("Not A Directory").initErrno(2);
        }
        return zipEntry;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Must specify ZIP file");
            System.exit(-1);
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        File file = new File(stringArray[stringArray.length - 1]);
        try {
            FuseMount.mount(stringArray2, new ZipFilesystem(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

