

package easyFS;

public class EasyFSPathDecoder {

	private String[] spath;
	private String path;
	
	public EasyFSPathDecoder(String path) {
		this.path = path;
		if (isDirectory())
		{
			path = path.substring(7);
			if (path.startsWith("/"))
				path = path.substring(1);
			if (path.endsWith("/"))
				path = path.substring(0, path.length()-1);
			
			spath = path.split("/");
		}
	
	}
	
	public boolean isDirectory()
	{
		return path.startsWith("/");
	}
	
	public String getDirectory()
	{
		if (hasDirectory())
			return spath[0];
		else
			return null;
	}
	
	public boolean hasFile()
	{
		return spath != null && spath.length == 2;
	}
	public boolean hasDirectory()
	{
		return spath != null && spath.length > 0 && spath[0].length() >0;
	}
	
	public String getPhoto()
	{
		if (hasFile())
			return spath[1];
		else
			return null;
	}
	
}
