package parseurs;

import java.io.*;

import javax.xml.parsers.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import donnees.Reponse;


public class ParseurRequete extends DefaultHandler{
	
	private SAXParser parseur;
	private Reponse rep;
	private int numParam;

	public ParseurRequete(){	
		super();
		// creation d'un parseur SAX
        try{
        	parseur = SAXParserFactory.newInstance().newSAXParser();			
        }
        catch(ParserConfigurationException pce)
        {
           System.out.println("Erreur de configuration du parseur");
        }
        catch (SAXException e) {
			System.out.println("Erreur Sax");
			e.printStackTrace();
		}      
	}
	
	public Reponse go (String reponseXML, int nbParam){		
        rep = new Reponse(nbParam);
        numParam = 0;
        try{
        ByteArrayInputStream str = new ByteArrayInputStream(reponseXML.getBytes());
		parseur.parse(str, this); 
		}

	     catch(SAXException se){
	        System.out.println("Erreur de parsing");
	        System.out.println("Lors de l'appel a parse()");
	        se.printStackTrace();
	     }
	     catch(IOException ioe){
	        System.out.println("Erreur d'entree/sortie");
	        System.out.println("Lors de l'appel a parse()");
	     }
        return rep;
	}
	
	//Surcharge des m�thodes de parsage :
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException{
		//balise <reponse code_retour="" />
		if(qName.equals("reponse")){
			rep.setCode(Integer.parseInt(attributes.getValue("code_retour"))); 
		}
		//balise <param name="" value="" />
		else if(qName.equals("param")){
			rep.setParam(attributes.getValue("name"),attributes.getValue("value"), numParam);
			numParam ++;
		}
		//balise inconnue, on balance une ch'tite exception
		else
			//throw new SAXException("Balise "+qName+" inconnue.");
			System.out.println("Balise "+qName+" inconnue.");
	}
	  
	
}
