/*
 * Decompiled with CFR 0.152.
 */
package fuse.compat;

import fuse.Filesystem3;
import fuse.FuseDirFiller;
import fuse.FuseException;
import fuse.FuseGetattrSetter;
import fuse.FuseOpenSetter;
import fuse.FuseStatfs;
import fuse.FuseStatfsSetter;
import fuse.compat.Filesystem2;
import fuse.compat.FuseDirEnt;
import fuse.compat.FuseStat;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Filesystem2ToFilesystem3Adapter
implements Filesystem3 {
    private Filesystem2 fs2;

    public Filesystem2ToFilesystem3Adapter(Filesystem2 filesystem2) {
        this.fs2 = filesystem2;
    }

    @Override
    public int getattr(String string, FuseGetattrSetter fuseGetattrSetter) throws FuseException {
        FuseStat fuseStat = this.fs2.getattr(string);
        fuseGetattrSetter.set(fuseStat.inode, fuseStat.mode, fuseStat.nlink, fuseStat.uid, fuseStat.gid, 0, fuseStat.size, fuseStat.blocks, fuseStat.atime, fuseStat.mtime, fuseStat.ctime);
        return 0;
    }

    @Override
    public int chmod(String string, int n) throws FuseException {
        this.fs2.chmod(string, n);
        return 0;
    }

    @Override
    public int chown(String string, int n, int n2) throws FuseException {
        this.fs2.chown(string, n, n2);
        return 0;
    }

    @Override
    public int flush(String string, Object object) throws FuseException {
        this.fs2.flush(string, object == null ? 0L : (Long)object);
        return 0;
    }

    @Override
    public int fsync(String string, Object object, boolean bl) throws FuseException {
        this.fs2.fsync(string, object == null ? 0L : (Long)object, bl);
        return 0;
    }

    @Override
    public int getdir(String string, FuseDirFiller fuseDirFiller) throws FuseException {
        for (FuseDirEnt fuseDirEnt : this.fs2.getdir(string)) {
            fuseDirFiller.add(fuseDirEnt.name, fuseDirEnt.inode, fuseDirEnt.mode);
        }
        return 0;
    }

    @Override
    public int link(String string, String string2) throws FuseException {
        this.fs2.link(string, string2);
        return 0;
    }

    @Override
    public int mkdir(String string, int n) throws FuseException {
        this.fs2.mkdir(string, n);
        return 0;
    }

    @Override
    public int mknod(String string, int n, int n2) throws FuseException {
        this.fs2.mknod(string, n, n2);
        return 0;
    }

    @Override
    public int open(String string, int n, FuseOpenSetter fuseOpenSetter) throws FuseException {
        fuseOpenSetter.setFh(new Long(this.fs2.open(string, n)));
        return 0;
    }

    @Override
    public int read(String string, Object object, ByteBuffer byteBuffer, long l) throws FuseException {
        this.fs2.read(string, object == null ? 0L : (Long)object, byteBuffer, l);
        return 0;
    }

    @Override
    public int readlink(String string, CharBuffer charBuffer) throws FuseException {
        charBuffer.put(this.fs2.readlink(string));
        return 0;
    }

    @Override
    public int release(String string, Object object, int n) throws FuseException {
        this.fs2.release(string, object == null ? 0L : (Long)object, n);
        return 0;
    }

    @Override
    public int rename(String string, String string2) throws FuseException {
        this.fs2.rename(string, string2);
        return 0;
    }

    @Override
    public int rmdir(String string) throws FuseException {
        this.fs2.rmdir(string);
        return 0;
    }

    @Override
    public int statfs(FuseStatfsSetter fuseStatfsSetter) throws FuseException {
        FuseStatfs fuseStatfs = this.fs2.statfs();
        fuseStatfsSetter.set(fuseStatfs.blockSize, fuseStatfs.blocks, fuseStatfs.blocksFree, fuseStatfs.blocksAvail, fuseStatfs.files, fuseStatfs.filesFree, fuseStatfs.namelen);
        return 0;
    }

    @Override
    public int symlink(String string, String string2) throws FuseException {
        this.fs2.symlink(string, string2);
        return 0;
    }

    @Override
    public int truncate(String string, long l) throws FuseException {
        this.fs2.truncate(string, l);
        return 0;
    }

    @Override
    public int unlink(String string) throws FuseException {
        this.fs2.unlink(string);
        return 0;
    }

    @Override
    public int utime(String string, int n, int n2) throws FuseException {
        this.fs2.utime(string, n, n2);
        return 0;
    }

    @Override
    public int write(String string, Object object, boolean bl, ByteBuffer byteBuffer, long l) throws FuseException {
        this.fs2.write(string, object == null ? 0L : (Long)object, bl, byteBuffer, l);
        return 0;
    }
}

