/*
 * Decompiled with CFR 0.152.
 */
package fuse.staticfs;

import fuse.FuseException;
import fuse.compat.FuseStat;
import fuse.staticfs.FileNode;
import java.nio.ByteBuffer;

public class ReadOnlyFileNode
extends FileNode {
    private byte[] content;

    public ReadOnlyFileNode(String string) {
        this(string, new byte[0]);
    }

    public ReadOnlyFileNode(String string, byte[] byArray) {
        super(string);
        this.setContent(byArray);
    }

    @Override
    protected FuseStat createStat() {
        FuseStat fuseStat = new FuseStat();
        fuseStat.mode = 33060;
        fuseStat.gid = 0;
        fuseStat.uid = 0;
        fuseStat.mtime = fuseStat.atime = (int)(System.currentTimeMillis() / 1000L);
        fuseStat.ctime = fuseStat.atime;
        fuseStat.size = 0L;
        fuseStat.blocks = 0;
        return fuseStat;
    }

    @Override
    public synchronized void read(ByteBuffer byteBuffer, long l) throws FuseException {
        if (l >= (long)this.content.length) {
            return;
        }
        int n = byteBuffer.capacity();
        if (l + (long)n > (long)this.content.length) {
            n = this.content.length - (int)l;
        }
        byteBuffer.put(this.content, (int)l, n);
    }

    @Override
    public void write(ByteBuffer byteBuffer, long l) throws FuseException {
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void open(int n) throws FuseException {
        if (n == 2 || n == 1) {
            throw new FuseException("Read Only").initErrno(30);
        }
    }

    @Override
    public void release(int n) throws FuseException {
    }

    @Override
    public void truncate(long l) throws FuseException {
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void utime(int n, int n2) throws FuseException {
    }

    public synchronized byte[] getContent() {
        return this.content;
    }

    public synchronized void setContent(byte[] byArray) {
        FuseStat fuseStat = (FuseStat)super.getStat().clone();
        if (this.content == null) {
            fuseStat.ctime = (int)(System.currentTimeMillis() / 1000L);
        }
        this.content = byArray;
        fuseStat.mtime = fuseStat.atime = (int)(System.currentTimeMillis() / 1000L);
        fuseStat.size = byArray.length;
        fuseStat.blocks = (byArray.length + 511) / 512;
        super.setStat(fuseStat);
    }
}

