/*
 * Decompiled with CFR 0.152.
 */
package fuse.staticfs;

import fuse.FuseException;
import fuse.FuseStatfs;
import fuse.compat.Filesystem1;
import fuse.compat.FuseDirEnt;
import fuse.compat.FuseStat;
import fuse.staticfs.DirectoryNode;
import fuse.staticfs.FileNode;
import fuse.staticfs.MountpointNode;
import fuse.staticfs.Node;
import fuse.staticfs.SymlinkNode;
import java.nio.ByteBuffer;

public class StaticFilesystem
implements Filesystem1 {
    DirectoryNode rootNode;
    FuseStatfs statfs;

    public StaticFilesystem(DirectoryNode directoryNode) {
        this.rootNode = directoryNode;
        this.statfs = new FuseStatfs();
        this.statfs.blocks = 0;
        this.statfs.blocksFree = 0;
        this.statfs.blockSize = 8192;
        this.statfs.files = 0;
        this.statfs.filesFree = 0;
        this.statfs.namelen = 2048;
    }

    public DirectoryNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public void chmod(String string, int n) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().chmod(resolveResult.path, n);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void chown(String string, int n, int n2) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().chown(resolveResult.path, n, n2);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public FuseStat getattr(String string) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            return ((MountpointNode)resolveResult.node).getFilesystem().getattr(resolveResult.path);
        }
        return resolveResult.node.getStat();
    }

    @Override
    public FuseDirEnt[] getdir(String string) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            return ((MountpointNode)resolveResult.node).getFilesystem().getdir(resolveResult.path);
        }
        if (!(resolveResult.node instanceof DirectoryNode)) {
            throw new FuseException("Not a Directory").initErrno(20);
        }
        Node[] nodeArray = ((DirectoryNode)resolveResult.node).getChildren();
        FuseDirEnt[] fuseDirEntArray = new FuseDirEnt[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            FuseStat fuseStat = node instanceof MountpointNode ? ((MountpointNode)node).getFilesystem().getattr("/") : node.getStat();
            FuseDirEnt fuseDirEnt = new FuseDirEnt();
            fuseDirEnt.name = node.getName();
            fuseDirEnt.mode = fuseStat.mode;
            fuseDirEntArray[i] = fuseDirEnt;
        }
        return fuseDirEntArray;
    }

    @Override
    public void link(String string, String string2) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        ResolveResult resolveResult2 = this.resolveParentPath(string2);
        boolean bl = resolveResult.node instanceof MountpointNode;
        boolean bl2 = resolveResult2.node instanceof MountpointNode;
        if (bl || bl2) {
            if (!bl || !bl2 || resolveResult.node != resolveResult2.node) {
                throw new FuseException("Cross Device Link not possible").initErrno(18);
            }
        } else {
            throw new FuseException("Read Only").initErrno(30);
        }
        ((MountpointNode)resolveResult.node).getFilesystem().link(resolveResult.path, resolveResult2.path);
    }

    @Override
    public void mkdir(String string, int n) throws FuseException {
        ResolveResult resolveResult = this.resolveParentPath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().mkdir(resolveResult.path, n);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void mknod(String string, int n, int n2) throws FuseException {
        ResolveResult resolveResult = this.resolveParentPath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().mknod(resolveResult.path, n, n2);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void open(String string, int n) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().open(resolveResult.path, n);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).open(n);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    @Override
    public void read(String string, ByteBuffer byteBuffer, long l) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().read(resolveResult.path, byteBuffer, l);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).read(byteBuffer, l);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    @Override
    public String readlink(String string) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            return ((MountpointNode)resolveResult.node).getFilesystem().readlink(resolveResult.path);
        }
        if (resolveResult.node instanceof SymlinkNode) {
            return ((SymlinkNode)resolveResult.node).getTarget();
        }
        throw new FuseException("Not a Symbolic Link").initErrno(22);
    }

    @Override
    public void release(String string, int n) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().release(resolveResult.path, n);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).release(n);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    @Override
    public void rename(String string, String string2) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        ResolveResult resolveResult2 = this.resolveParentPath(string2);
        boolean bl = resolveResult.node instanceof MountpointNode;
        boolean bl2 = resolveResult2.node instanceof MountpointNode;
        if (bl || bl2) {
            if (!bl || !bl2 || resolveResult.node != resolveResult2.node) {
                throw new FuseException("Cross Device Rename not possible").initErrno(18);
            }
        } else {
            throw new FuseException("Read Only").initErrno(30);
        }
        ((MountpointNode)resolveResult.node).getFilesystem().rename(resolveResult.path, resolveResult2.path);
    }

    @Override
    public void rmdir(String string) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().rmdir(resolveResult.path);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public FuseStatfs statfs() throws FuseException {
        return this.statfs;
    }

    @Override
    public void symlink(String string, String string2) throws FuseException {
        ResolveResult resolveResult = this.resolveParentPath(string2);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().symlink(string, resolveResult.path);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void truncate(String string, long l) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().truncate(resolveResult.path, l);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).truncate(l);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    @Override
    public void unlink(String string) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().unlink(resolveResult.path);
            return;
        }
        throw new FuseException("Read Only").initErrno(30);
    }

    @Override
    public void utime(String string, int n, int n2) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().utime(resolveResult.path, n, n2);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).utime(n, n2);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    @Override
    public void write(String string, ByteBuffer byteBuffer, long l) throws FuseException {
        ResolveResult resolveResult = this.resolvePath(string);
        if (resolveResult.node instanceof MountpointNode) {
            ((MountpointNode)resolveResult.node).getFilesystem().write(resolveResult.path, byteBuffer, l);
            return;
        }
        if (resolveResult.node instanceof FileNode) {
            ((FileNode)resolveResult.node).read(byteBuffer, l);
            return;
        }
        throw new FuseException("Not a File").initErrno(22);
    }

    private ResolveResult resolveParentPath(String string) throws FuseException {
        return this.resolvePath(string, true);
    }

    private ResolveResult resolvePath(String string) throws FuseException {
        return this.resolvePath(string, false);
    }

    private ResolveResult resolvePath(String string, boolean bl) throws FuseException {
        String string2;
        DirectoryNode directoryNode = this.rootNode;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && !(directoryNode instanceof MountpointNode)) {
            while (n < string.length() && string.charAt(n) == '/') {
                n2 = n++;
            }
            if (n >= string.length()) break;
            int n3 = n;
            while (n < string.length() && string.charAt(n) != '/') {
                ++n;
            }
            if (bl && n >= string.length()) break;
            String string3 = string.substring(n3, n);
            if (!string3.equals(".")) {
                Node node;
                if (string3.equals("..")) {
                    node = directoryNode.getParent();
                    if (node != null) {
                        directoryNode = node;
                    }
                } else {
                    node = null;
                    if (directoryNode instanceof DirectoryNode && (node = directoryNode.getChild(string3)) != null) {
                        directoryNode = node;
                    } else {
                        throw new FuseException("No such node").initErrno(2);
                    }
                }
            }
            n2 = n;
        }
        if ((string2 = string.substring(n2)).length() == 0 && directoryNode instanceof MountpointNode) {
            string2 = "/";
        }
        return new ResolveResult(string2, directoryNode);
    }

    static class ResolveResult {
        String path;
        Node node;

        ResolveResult(String string, Node node) {
            this.path = string;
            this.node = node;
        }
    }
}

