package donnees;

import java.util.ArrayList;
import java.util.List;

public class Repertoire {
	
	public int idRep;
	public int idRepParent;
	public int idProprietaire;
	public String nom;
	public String derniereModif;
	public int droits;
	public int id_groupe;
	
	public List<Repertoire> listeRep = new ArrayList<Repertoire>();
	public List<Fichier> listeFichier =  new ArrayList<Fichier>();
	
	public Repertoire repParent;
	
	public Repertoire()
	{
		this.idRep = 0;
		this.idRepParent = 0;
		this.nom = "";
		this.droits = 0;
		this.idProprietaire = 0;
		this.derniereModif = "";
		this.id_groupe = 0;
		this.repParent = null;
	}

	public Repertoire(int id_rep, int rep_parent, String nom, int droits, int proprietaire, String derniere_modif,int id_groupe,Repertoire repParent)
	{
		this.idRep = id_rep;
		this.idRepParent = rep_parent;
		this.nom = nom;
		this.droits = droits;
		this.idProprietaire = proprietaire;
		this.derniereModif = derniere_modif;
		this.id_groupe = id_groupe;
		this.repParent = repParent;
	}
	
	public String toString()
	{
		String s ="(Repertoire) ";
		s+= "idRep: "+this.idRep;
		s+= " idRepParent: "+this.idRepParent ;
		s+= " idProprietaire: "+this.idProprietaire;
		s+= " nom: "+this.nom;
		s+= " derniereModif: "+this.derniereModif;
		s+= " droits: "+this.droits;
		s+=" id_groupe: "+this.id_groupe;
		
		for (Object object : this.listeFichier) 
		{
			Fichier f = (Fichier) object;
			s+="\n"+f.toString(); 
		}
		
		for(Object object : this.listeRep)
		{
			Repertoire sr = (Repertoire)object;
			s+="\n"+sr.toString();
		}
		
		return s;
	}
	
	public void ajouterFichier(Fichier fichier)
	{
		this.listeFichier.add(fichier);
	}
	
	public void ajouterSousRep(Repertoire sousRep)
	{
		this.listeRep.add(sousRep);
	}
	
	public Repertoire parent(){
		return this.repParent;
	}

}
