package ParseurCommandes;


import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.*; 
import java.io.*; 


public class parseur extends DefaultHandler{
   //rsultats de notre parsing
   private parametre unParametre;
   private requete uneRequete;
   private reponse uneReponse;
   
   //flags nous indiquant la position du parseur
   private boolean inParametre=false;
   private boolean inRequete=false;
   private boolean inReponse=false;
   
   // simple constructeur
   public parseur(){
      super();	
      
   }
   //dtection d'ouverture de balise
   public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException{
	   
      System.out.println(uri+" "+localName+" "+qName);
      
      if(qName.equals("requete"))
      { 
    	  uneRequete = new requete();
    	  inRequete = true;
    	  inReponse = false;
    	  try
    	  {
    		  String action = attributes.getValue("action");
    		  uneRequete.action=action;
    	  }
    	  catch(Exception e)
    	  {
           	//erreur dans le contenu
              throw new SAXException(e);
    	  }

      }
      
      else if(qName.equals("param"))
      {
    	  unParametre = new parametre();
         try{	         	
	         	String name = attributes.getValue("name");
	         	unParametre.nom = name;
	         	
	         	String value = attributes.getValue("value");
	         	unParametre.valeur = value;
	         	
	         	try
	         	{
	         		if(inRequete==true)
	         		{
	         			this.uneRequete.parametres.add(this.unParametre);
	         		}
	         		else
	         		{
	         			this.uneReponse.parametres.add(this.unParametre);
	         		}
	         	}
	         	catch(Exception e)
	         	{
	         		System.out.println("Erreur lors de l'insertion du paramtre");
	         	}
	         	
         	}
         
         catch(Exception e){
         	//erreur dans le contenu
            throw new SAXException(e);
         }
         
      }
      
      else if(qName.equals("reponse"))
      {
    	  inReponse = true;	
    	  inRequete = false;
    	  
    	  this.uneReponse = new reponse();
    	  
    	  try
    	  {
    		  int codeRetour = Integer.parseInt(attributes.getValue("code_retour"));
    		  this.uneReponse.code_retour = codeRetour;
    		 
    	  }
    	  catch(Exception e)
    	  {
           	//erreur dans le contenu
              throw new SAXException(e);
    	  }
    	  
      }
     
      else{
         //erreur, on peut lever une exception
         throw new SAXException("Balise "+qName+" inconnue.");	
      }
   }
   

   
   //dtection fin de balise
   public void endElement(String uri,String localName, String qName) throws SAXException{
      
	   if(qName.equals("reponse")){
       
		   inReponse = false;
      }
      
      else if(qName.equals("requete")){
         inRequete = false;	
      }
      
      else if(qName.equals("param")){
         inParametre = false;
         //fin du traitement
      }
      
      else{
         //erreur, on peut lever une exception
         throw new SAXException("Balise "+qName+" inconnue.");	
      }          	
   }
   
   
   //dbut du parsing
   public void startDocument() throws SAXException {
   	  System.out.println("Dbut du parsing");
   }
   
   //fin du parsing
   public void endDocument() throws SAXException {
   	  System.out.println("Fin du parsing");
   	  System.out.println("Resultats du parsing");
   	  
   	  //Affichage du rsultat
   	 // System.out.println("Requete: "+this.uneRequete.toString());
   	System.out.println("Reponse: "+this.uneReponse.toString());
   	  
   }
   
   // test
   public static void main(String[] args){
      try{
         // cration d'une fabrique de parseurs SAX
         SAXParserFactory fabrique = SAXParserFactory.newInstance();
			
         // cration d'un parseur SAX
         SAXParser parseur = fabrique.newSAXParser();
			
         // lecture d'un fichier XML avec un DefaultHandler
         File fichier = new File("./testParseurCommandes.xml");
         DefaultHandler gestionnaire = new parseur();
         parseur.parse(fichier, gestionnaire);
		
      }catch(ParserConfigurationException pce)
      {
         System.out.println("Erreur de configuration du parseur");
         System.out.println("Lors de l'appel  SAXParser.newSAXParser()");
      }
      catch(SAXException se)
      {
         System.out.println("Erreur de parsing");
         System.out.println("Lors de l'appel  parse()");
         se.printStackTrace();
      }
      catch(IOException ioe)
      {
         System.out.println("Erreur d'entre/sortie");
         System.out.println("Lors de l'appel  parse()");
      }

   }	
}