/*
 * Decompiled with CFR 0.152.
 */
package fuse;

import fuse.Filesystem3;
import fuse.FuseDirFiller;
import fuse.FuseException;
import fuse.FuseGetattrSetter;
import fuse.FuseMount;
import fuse.FuseOpenSetter;
import fuse.FuseSizeSetter;
import fuse.FuseStatfsSetter;
import fuse.XattrLister;
import fuse.XattrSupport;
import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FakeFilesystem
implements Filesystem3,
XattrSupport {
    private static final Log log = LogFactory.getLog(FakeFilesystem.class);
    private static final int BLOCK_SIZE = 512;
    private static final int NAME_LENGTH = 1024;
    private D root = new D("", 493, "description", "ROOT directory");

    private N lookup(String string) {
        N n;
        if (string.equals("/")) {
            return this.root;
        }
        File file = new File(string);
        N n2 = this.lookup(file.getParent());
        N n3 = n = n2 instanceof D ? ((D)n2).files.get(file.getName()) : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  lookup(\"" + string + "\") returning: " + n));
        }
        return n;
    }

    public FakeFilesystem() {
        this.root.add(new F("README", 420, "Hou have read me\n", new String[]{"mimetype", "text/plain", "description", "a README file"}));
        this.root.add(new F("execute_me.sh", 493, "#!/bin/sh\n\necho \"You executed me\"\n", new String[]{"mimetype", "text/plain", "description", "a BASH script"}));
        D d = new D("subdir", 493, "description", "a subdirectory");
        this.root.add(d);
        d.add(new L("README.link", 438, "../README", new String[]{"description", "a symbolic link"}));
        d.add(new L("execute_me.link.sh", 438, "../execute_me.sh", new String[]{"description", "another symbolic link"}));
        log.info((Object)"created");
    }

    @Override
    public int chmod(String string, int n) throws FuseException {
        N n2 = this.lookup(string);
        if (n2 != null) {
            n2.mode = n2.mode & 0xF000 | n & 0xFFF;
            return 0;
        }
        return 2;
    }

    @Override
    public int chown(String string, int n, int n2) throws FuseException {
        return 0;
    }

    @Override
    public int getattr(String string, FuseGetattrSetter fuseGetattrSetter) throws FuseException {
        N n = this.lookup(string);
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        if (n instanceof D) {
            D d = (D)n;
            fuseGetattrSetter.set(d.hashCode(), 0x4000 | d.mode, 1, 0, 0, 0, d.files.size() * 1024, (d.files.size() * 1024 + 512 - 1) / 512, n2, n2, n2);
            return 0;
        }
        if (n instanceof F) {
            F f = (F)n;
            fuseGetattrSetter.set(f.hashCode(), 0x8000 | f.mode, 1, 0, 0, 0, f.content.length, (f.content.length + 512 - 1) / 512, n2, n2, n2);
            return 0;
        }
        if (n instanceof L) {
            L l = (L)n;
            fuseGetattrSetter.set(l.hashCode(), 0xA000 | l.mode, 1, 0, 0, 0, l.link.length(), (l.link.length() + 512 - 1) / 512, n2, n2, n2);
            return 0;
        }
        return 2;
    }

    @Override
    public int getdir(String string, FuseDirFiller fuseDirFiller) throws FuseException {
        N n = this.lookup(string);
        if (n instanceof D) {
            for (N n2 : ((D)n).files.values()) {
                int n3 = n2 instanceof D ? 16384 : (n2 instanceof F ? 32768 : (n2 instanceof L ? 40960 : 0));
                if (n3 <= 0) continue;
                fuseDirFiller.add(n2.name, n2.hashCode(), n3 | n2.mode);
            }
            return 0;
        }
        return 20;
    }

    @Override
    public int link(String string, String string2) throws FuseException {
        return 30;
    }

    @Override
    public int mkdir(String string, int n) throws FuseException {
        return 30;
    }

    @Override
    public int mknod(String string, int n, int n2) throws FuseException {
        return 30;
    }

    @Override
    public int rename(String string, String string2) throws FuseException {
        return 30;
    }

    @Override
    public int rmdir(String string) throws FuseException {
        return 30;
    }

    @Override
    public int statfs(FuseStatfsSetter fuseStatfsSetter) throws FuseException {
        fuseStatfsSetter.set(512, 1000, 200, 180, N.nfiles, 0, 1024);
        return 0;
    }

    @Override
    public int symlink(String string, String string2) throws FuseException {
        return 30;
    }

    @Override
    public int truncate(String string, long l) throws FuseException {
        return 30;
    }

    @Override
    public int unlink(String string) throws FuseException {
        return 30;
    }

    @Override
    public int utime(String string, int n, int n2) throws FuseException {
        return 0;
    }

    @Override
    public int readlink(String string, CharBuffer charBuffer) throws FuseException {
        N n = this.lookup(string);
        if (n instanceof L) {
            charBuffer.append(((L)n).link);
            return 0;
        }
        return 2;
    }

    @Override
    public int open(String string, int n, FuseOpenSetter fuseOpenSetter) throws FuseException {
        N n2 = this.lookup(string);
        if (n2 != null) {
            fuseOpenSetter.setFh(new FH(n2));
            return 0;
        }
        return 2;
    }

    @Override
    public int write(String string, Object object, boolean bl, ByteBuffer byteBuffer, long l) throws FuseException {
        return 30;
    }

    @Override
    public int read(String string, Object object, ByteBuffer byteBuffer, long l) throws FuseException {
        if (object instanceof FH) {
            F f = (F)((FH)object).n;
            byteBuffer.put(f.content, (int)l, Math.min(byteBuffer.remaining(), f.content.length - (int)l));
            return 0;
        }
        return 9;
    }

    @Override
    public int flush(String string, Object object) throws FuseException {
        if (object instanceof FH) {
            return 0;
        }
        return 9;
    }

    @Override
    public int fsync(String string, Object object, boolean bl) throws FuseException {
        if (object instanceof FH) {
            return 0;
        }
        return 9;
    }

    @Override
    public int release(String string, Object object, int n) throws FuseException {
        if (object instanceof FH) {
            ((FH)object).release();
            System.runFinalization();
            return 0;
        }
        return 9;
    }

    @Override
    public int getxattr(String string, String string2, ByteBuffer byteBuffer) throws FuseException, BufferOverflowException {
        N n = this.lookup(string);
        if (n == null) {
            return 2;
        }
        byte[] byArray = n.xattrs.get(string2);
        if (byArray == null) {
            return 61;
        }
        byteBuffer.put(byArray);
        return 0;
    }

    @Override
    public int getxattrsize(String string, String string2, FuseSizeSetter fuseSizeSetter) throws FuseException {
        N n = this.lookup(string);
        if (n == null) {
            return 2;
        }
        byte[] byArray = n.xattrs.get(string2);
        if (byArray == null) {
            return 61;
        }
        fuseSizeSetter.setSize(byArray.length);
        return 0;
    }

    @Override
    public int listxattr(String string, XattrLister xattrLister) throws FuseException {
        N n = this.lookup(string);
        if (n == null) {
            return 2;
        }
        for (String string2 : n.xattrs.keySet()) {
            xattrLister.add(string2);
        }
        return 0;
    }

    @Override
    public int removexattr(String string, String string2) throws FuseException {
        return 30;
    }

    @Override
    public int setxattr(String string, String string2, ByteBuffer byteBuffer, int n) throws FuseException {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        log.info((Object)"entering");
        try {
            FuseMount.mount(stringArray, new FakeFilesystem(), log);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            log.info((Object)"exiting");
        }
    }

    private static class FH {
        N n;

        FH(N n) {
            this.n = n;
            log.debug((Object)("  " + this + " created"));
        }

        void release() {
            log.debug((Object)("  " + this + " released"));
        }

        protected void finalize() {
            log.debug((Object)("  " + this + " finalized"));
        }

        public String toString() {
            return "FH[" + this.n + ", hashCode=" + this.hashCode() + "]";
        }
    }

    private static class L
    extends N {
        String link;

        L(String string, int n, String string2, String ... stringArray) {
            super(string, n, stringArray);
            this.link = string2;
        }
    }

    private static class F
    extends N {
        byte[] content;

        F(String string, int n, String string2, String ... stringArray) {
            super(string, n, stringArray);
            this.content = string2.getBytes();
        }
    }

    private static class D
    extends N {
        Map<String, N> files = new LinkedHashMap<String, N>();

        D(String string, int n, String ... stringArray) {
            super(string, n, stringArray);
        }

        void add(N n) {
            this.files.put(n.name, n);
        }

        @Override
        public String toString() {
            return super.toString() + " with " + this.files.size() + " files";
        }
    }

    private static class N {
        static int nfiles = 0;
        String name;
        int mode;
        Map<String, byte[]> xattrs = new HashMap<String, byte[]>();

        N(String string, int n, String ... stringArray) {
            this.name = string;
            this.mode = n;
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                this.xattrs.put(stringArray[i], stringArray[i + 1].getBytes());
            }
            ++nfiles;
        }

        public String toString() {
            String string = this.getClass().getName();
            return string.substring(string.indexOf("$")) + "[ name=" + this.name + ", mode=" + Integer.toOctalString(this.mode) + "(OCT) ]";
        }
    }
}

