package ParseurArborescence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


public class RepGroupe {
	
	public int id_rep;
	public int rep_parent;
	public String nom;
	public int droits;
	public int proprietaire;
	public String derniere_modif;
	public int id_groupe;
	
	public List<SousRep> listeRep = new ArrayList<SousRep>();
	public List<Fichier> listeFichier =  new ArrayList<Fichier>();
	
	public RepGroupe()
	{
		this.id_rep = 0;
		this.rep_parent = 0;
		this.nom = "";
		this.droits = 0;
		this.proprietaire = 0;
		this.derniere_modif = "";
		this.id_groupe = 0;
	}
	
	public RepGroupe(int id_rep, int rep_parent, String nom, int droits, int proprietaire, String derniere_modif,int id_groupe)
	{
		this.id_rep = id_rep;
		this.rep_parent = rep_parent;
		this.nom = nom;
		this.droits = droits;
		this.proprietaire = proprietaire;
		this.derniere_modif = derniere_modif;
		this.id_groupe = id_groupe;
	}
	
	public String toString()
	{
		String s ="(RepGroupe) ";
		s+= "idRep: "+this.id_rep;
		s+= " idRepParent: "+this.rep_parent ;
		s+= " idProprietaire: "+this.proprietaire;
		s+= " nom: "+this.nom;
		s+= " derniereModif: "+this.derniere_modif;
		s+= " droits: "+this.droits;
		s+=" id_groupe: "+this.id_groupe;
		
		for (Object object : this.listeFichier) 
		{
			Fichier f = (Fichier) object;
			s+="\n"+f.toString(); 
			//System.out.println(personne.getNom());
		}
		
		for(Object object : this.listeRep)
		{
			SousRep sr = (SousRep)object;
			s+="\n"+sr.toString();
		}
		
		return s;
	}
	
	public void ajouterFichier(Fichier fichier)
	{
		this.listeFichier.add(fichier);
	}
	
	public void ajouterSousRep(SousRep sousRep)
	{
		this.listeRep.add(sousRep);
	}
	
	public int posSousRep(int idSousRep)
	{
		int i =0;
		
		while(this.listeRep.iterator().hasNext())
		{
			if(this.listeRep.get(i).idRep==idSousRep) return i;
			else i++;
		}
		
		return -1;
	}
	
	private static SousRep ajouterSousRep(SousRep repDeRecherche, int idSousRep, SousRep sr)
	{
		SousRep SousRep2 = repDeRecherche;
		
		Iterator i = repDeRecherche.listeRep.iterator();
		while(i.hasNext())
		{
			SousRep element = (SousRep) i.next();
			if(element.idRep==idSousRep)
				{
				SousRep2.listeRep.remove(element);
				element.listeRep.add(sr);
				SousRep2.listeRep.add(element);
					
				}
			else ajouterSousRep(element, idSousRep,sr);
		}
		
		return SousRep2;
	}
	
	public static RepGroupe ajouterSousRep(RepGroupe repGroupe, int idSousRep, SousRep sr)
	{
		RepGroupe repGroupe2 = repGroupe;
		
		for(SousRep ssr : repGroupe.listeRep)
		{
			if(ssr.idRep==idSousRep)
			{
				repGroupe2.listeRep.remove(ssr);
				ssr.listeRep.add(sr);
				repGroupe2.listeRep.add(ssr);
			}
			else
				{
					repGroupe2.listeRep.remove(ssr);
					repGroupe2.listeRep.add(ajouterSousRep(sr, idSousRep,sr));
				}
		}
		
		return repGroupe2;
	}
	
	private static SousRep ajouterFichier(SousRep repDeRecherche, int idSousRep, Fichier f)
	{
		SousRep SousRep2 = repDeRecherche;
		
		Iterator i = repDeRecherche.listeRep.iterator();
		while(i.hasNext())
		{
			SousRep element = (SousRep) i.next();
			if(element.idRep==idSousRep)
				{
				SousRep2.listeFichier.remove(f);
				element.listeFichier.add(f);
				SousRep2.listeRep.add(element);
					
				}
			else ajouterFichier(element, idSousRep,f);
		}
		
		return SousRep2;
	}
	
	public static RepGroupe ajouterFichier(RepGroupe repGroupe, int idSousRep, Fichier f)
	{
		RepGroupe repGroupe2 = repGroupe;
		
		for(SousRep ssr : repGroupe.listeRep)
		{
			if(ssr.idRep==idSousRep)
			{
				repGroupe2.listeRep.remove(ssr);
				ssr.listeFichier.add(f);
				repGroupe2.listeRep.add(ssr);
			}
			else
				{
					repGroupe2.listeRep.remove(ssr);
					repGroupe2.listeRep.add(ajouterFichier(ssr, idSousRep,f));
				}
		}
		
		return repGroupe2;
	}

}
