/*
 * Decompiled with CFR 0.152.
 */
package java2c;

import fuse.FuseContext;
import fuse.FuseFS;
import fuse.FuseFSDirEnt;
import fuse.FuseFSDirFiller;
import fuse.FuseGetattr;
import fuse.FuseOpen;
import fuse.FuseSize;
import fuse.FuseStatfs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

public class CAPIGenerator {
    private Class clazz;

    public CAPIGenerator(Class clazz) {
        this.clazz = clazz;
    }

    public void generateClassAPI(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, boolean bl2) {
        AccessibleObject accessibleObject;
        int n;
        Object object;
        int n2;
        Method[] methodArray;
        Constructor<?> constructor;
        Field[] fieldArray;
        String string = this.clazz.getName();
        String string2 = string.replace('.', '/');
        String string3 = "jclass_" + string.replace('.', '_');
        String string4 = string.replace('.', '_');
        Field[] fieldArray2 = this.clazz.getFields();
        ArrayList<Field[]> arrayList = new ArrayList<Field[]>();
        ArrayList<Field[]> arrayList2 = new ArrayList<Field[]>();
        for (int i = 0; i < fieldArray2.length; ++i) {
            fieldArray = fieldArray2[i];
            int n3 = fieldArray.getModifiers();
            if (!Modifier.isPublic(n3)) continue;
            if (Modifier.isStatic(n3)) {
                arrayList.add(fieldArray);
                continue;
            }
            arrayList2.add(fieldArray);
        }
        Field[] fieldArray3 = arrayList.toArray(new Field[arrayList.size()]);
        fieldArray = arrayList2.toArray(new Field[arrayList2.size()]);
        Constructor<?>[] constructorArray = this.clazz.getConstructors();
        ArrayList arrayList3 = new ArrayList();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < constructorArray.length; ++i) {
            constructor = constructorArray[i];
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            arrayList3.add(constructor);
            hashMap.put(constructor, this.getMethodName("new", constructor.getParameterTypes()));
        }
        constructorArray = arrayList3.toArray(new Constructor[arrayList3.size()]);
        Method[] methodArray2 = this.clazz.getMethods();
        constructor = new ArrayList();
        ArrayList<Method[]> arrayList4 = new ArrayList<Method[]>();
        HashMap<Method[], String> hashMap2 = new HashMap<Method[], String>();
        for (int i = 0; i < methodArray2.length; ++i) {
            methodArray = methodArray2[i];
            n2 = methodArray.getModifiers();
            if (!Modifier.isPublic(n2)) continue;
            if (Modifier.isStatic(n2)) {
                constructor.add(methodArray);
            } else {
                arrayList4.add(methodArray);
            }
            hashMap2.put(methodArray, this.getMethodName(methodArray.getName(), methodArray.getParameterTypes()));
        }
        Method[] methodArray3 = constructor.toArray(new Method[constructor.size()]);
        methodArray = arrayList4.toArray(new Method[arrayList4.size()]);
        printWriter.print("\n/**\n * structure with a reference to " + string + " java class and cached field & method IDs\n" + " */\n" + "typedef struct _" + string3 + "\n" + "{\n" + "   // a pointer to globaly referenced Java class\n" + "   jclass class;\n" + "\n");
        if (fieldArray3.length > 0 && bl2) {
            printWriter.print("   // cached static field IDs\n   struct\n   {\n");
            for (n2 = 0; n2 < fieldArray3.length; ++n2) {
                object = fieldArray3[n2];
                printWriter.print("      jfieldID " + ((Field)object).getName() + ";\n");
            }
            printWriter.print("\n   } static_field;\n\n");
        }
        if (fieldArray.length > 0) {
            printWriter.print("   // cached instance field IDs\n   struct\n   {\n");
            for (n2 = 0; n2 < fieldArray.length; ++n2) {
                object = fieldArray[n2];
                printWriter.print("      jfieldID " + ((Field)object).getName() + ";\n");
            }
            printWriter.print("\n   } field;\n\n");
        }
        if (constructorArray.length > 0) {
            printWriter.print("   // cached constructor IDs\n   struct\n   {\n");
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                object = constructorArray[n2];
                printWriter.print("      jmethodID " + hashMap.get(object) + ";\n");
            }
            printWriter.print("\n   } constructor;\n\n");
        }
        if (methodArray3.length > 0) {
            printWriter.print("   // cached static method IDs\n   struct\n   {\n");
            for (n2 = 0; n2 < methodArray3.length; ++n2) {
                object = methodArray3[n2];
                printWriter.print("      jmethodID " + hashMap2.get(object) + ";\n");
            }
            printWriter.print("\n   } static_method;\n\n");
        }
        if (methodArray.length > 0) {
            printWriter.print("   // cached instance method IDs\n   struct\n   {\n");
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                object = methodArray[n2];
                printWriter.print("      jmethodID " + hashMap2.get(object) + ";\n");
            }
            printWriter.print("\n   } method;\n\n");
        }
        printWriter.print("} " + string3 + ";\n" + "\n");
        printWriter.print("// free structure\nvoid free_" + string3 + "(JNIEnv *env, " + string3 + " *" + string4 + ");\n" + "\n");
        printWriter2.print("/**\n * free structure with a reference to " + string + " java class and cached field & method IDs\n" + " */\n" + "void free_" + string3 + "(JNIEnv *env, " + string3 + " *" + string4 + ")\n" + "{\n" + "   if (" + string4 + "->class != NULL)\n" + "      (*env)->DeleteGlobalRef(env, " + string4 + "->class);\n" + "\n" + "   free(" + string4 + ");\n" + "}\n" + "\n");
        n2 = bl && Modifier.isInterface(this.clazz.getModifiers()) ? 1 : 0;
        object = n2 != 0 ? ", const char *className" : "";
        String string5 = n2 != 0 ? "className" : "\"" + string2 + "\"";
        printWriter.print("// alloc structure\n" + string3 + " *alloc_" + string3 + "(JNIEnv *env" + (String)object + ");\n" + "\n");
        printWriter2.print("/**\n * alloc structure with a reference to " + string + " java class and cached field & method IDs\n" + " */\n" + string3 + " *alloc_" + string3 + "(JNIEnv *env" + (String)object + ")\n" + "{\n" + "   jclass class;\n" + "\n" + "   " + string3 + " *" + string4 + " = (" + string3 + "*)calloc(1, sizeof(" + string3 + "));\n" + "   if (" + string4 + " == NULL)\n" + "   {\n" + "      WARN(\"Can't allocate structure " + string3 + "\");\n" + "      return NULL;\n" + "   }\n" + "\n" + "   while (1)\n" + "   {\n" + "      class = (*env)->FindClass(env, " + string5 + ");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n" + "\n" + "      " + string4 + "->class = (*env)->NewGlobalRef(env, class);\n" + "      if ((*env)->ExceptionCheck(env)) break;\n" + "\n");
        if (fieldArray3.length > 0 && bl2) {
            printWriter2.print("      // obtain static field IDs\n");
            for (n = 0; n < fieldArray3.length; ++n) {
                accessibleObject = fieldArray3[n];
                printWriter2.print("      " + string4 + "->static_field." + ((Field)accessibleObject).getName() + " = (*env)->GetStaticFieldID(env, " + string4 + "->class, \"" + ((Field)accessibleObject).getName() + "\", \"" + this.getJVMTypeSignature(((Field)accessibleObject).getType()) + "\");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n");
            }
            printWriter2.print("\n");
        }
        if (fieldArray.length > 0) {
            printWriter2.print("      // obtain instance field IDs\n");
            for (n = 0; n < fieldArray.length; ++n) {
                accessibleObject = fieldArray[n];
                printWriter2.print("      " + string4 + "->field." + ((Field)accessibleObject).getName() + " = (*env)->GetFieldID(env, " + string4 + "->class, \"" + ((Field)accessibleObject).getName() + "\", \"" + this.getJVMTypeSignature(((Field)accessibleObject).getType()) + "\");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n");
            }
            printWriter2.print("\n");
        }
        if (constructorArray.length > 0) {
            printWriter2.print("      // obtain constructor method IDs\n");
            for (n = 0; n < constructorArray.length; ++n) {
                accessibleObject = constructorArray[n];
                printWriter2.print("      " + string4 + "->constructor." + hashMap.get(accessibleObject) + " = (*env)->GetMethodID(env, " + string4 + "->class, \"" + "<init>" + "\", \"" + this.getJVMConstructorSignature((Constructor)accessibleObject) + "\");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n");
            }
            printWriter2.print("\n");
        }
        if (methodArray3.length > 0) {
            printWriter2.print("      // obtain static method IDs\n");
            for (n = 0; n < methodArray3.length; ++n) {
                accessibleObject = methodArray3[n];
                printWriter2.print("      " + string4 + "->static_method." + hashMap2.get(accessibleObject) + " = (*env)->GetStaticMethodID(env, " + string4 + "->class, \"" + ((Method)accessibleObject).getName() + "\", \"" + this.getJVMMethodSignature((Method)accessibleObject) + "\");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n");
            }
            printWriter2.print("\n");
        }
        if (methodArray.length > 0) {
            printWriter2.print("      // obtain instance method IDs\n");
            for (n = 0; n < methodArray.length; ++n) {
                accessibleObject = methodArray[n];
                printWriter2.print("      " + string4 + "->method." + hashMap2.get(accessibleObject) + " = (*env)->GetMethodID(env, " + string4 + "->class, \"" + ((Method)accessibleObject).getName() + "\", \"" + this.getJVMMethodSignature((Method)accessibleObject) + "\");\n" + "      if ((*env)->ExceptionCheck(env)) break;\n");
            }
            printWriter2.print("\n");
        }
        printWriter2.print("      // we're done\n      return " + string4 + ";\n" + "   }\n" + "\n" + "   // error handler\n" + "   (*env)->ExceptionDescribe(env);\n" + "   (*env)->ExceptionClear(env);\n" + "   free_" + string3 + "(env, " + string4 + ");\n" + "   return NULL;\n" + "}\n" + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: " + CAPIGenerator.class.getName() + " file.h file.c common_include.h");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            printWriter2 = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            printWriter.print("/**\n * " + file.getName() + " - autogenerated C <-> Java bindings\n" + " */\n" + "\n" + "#include <jni.h>\n" + "\n");
            printWriter2.print("/**\n * " + file2.getName() + " - autogenerated C <-> Java bindings\n" + " */\n" + "\n" + "#include \"" + file3.getPath() + "\"\n" + "\n");
            new CAPIGenerator(FuseGetattr.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseFSDirEnt.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseFSDirFiller.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseStatfs.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseSize.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseOpen.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseContext.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(FuseFS.class).generateClassAPI(printWriter, printWriter2, false, false);
            new CAPIGenerator(ByteBuffer.class).generateClassAPI(printWriter, printWriter2, false, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
    }

    private String getJVMTypeSignature(Class clazz) {
        return this.appendJVMTypeSignature(clazz, new StringBuffer()).toString();
    }

    private String getJVMTypeSignatures(Class[] classArray) {
        return this.appendJVMTypeSignatures(classArray, new StringBuffer()).toString();
    }

    private String getJVMMethodSignature(Method method) {
        return this.appendJVMMethodSignature(method, new StringBuffer()).toString();
    }

    private String getJVMConstructorSignature(Constructor constructor) {
        return this.appendJVMConstructorSignature(constructor, new StringBuffer()).toString();
    }

    private StringBuffer appendJVMTypeSignature(Class clazz, StringBuffer stringBuffer) {
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz == Void.TYPE) {
            stringBuffer.append("V");
        } else if (clazz == Boolean.TYPE) {
            stringBuffer.append("Z");
        } else if (clazz == Byte.TYPE) {
            stringBuffer.append("B");
        } else if (clazz == Character.TYPE) {
            stringBuffer.append("C");
        } else if (clazz == Short.TYPE) {
            stringBuffer.append("S");
        } else if (clazz == Integer.TYPE) {
            stringBuffer.append("I");
        } else if (clazz == Long.TYPE) {
            stringBuffer.append("J");
        } else if (clazz == Float.TYPE) {
            stringBuffer.append("F");
        } else if (clazz == Double.TYPE) {
            stringBuffer.append("D");
        } else {
            stringBuffer.append("L").append(clazz.getName().replace('.', '/')).append(";");
        }
        return stringBuffer;
    }

    private StringBuffer appendJVMTypeSignatures(Class[] classArray, StringBuffer stringBuffer) {
        for (int i = 0; i < classArray.length; ++i) {
            this.appendJVMTypeSignature(classArray[i], stringBuffer);
        }
        return stringBuffer;
    }

    private StringBuffer appendJVMMethodSignature(Method method, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        this.appendJVMTypeSignatures(method.getParameterTypes(), stringBuffer);
        stringBuffer.append(")");
        this.appendJVMTypeSignature(method.getReturnType(), stringBuffer);
        return stringBuffer;
    }

    private StringBuffer appendJVMConstructorSignature(Constructor constructor, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        this.appendJVMTypeSignatures(constructor.getParameterTypes(), stringBuffer);
        stringBuffer.append(")V");
        return stringBuffer;
    }

    private String mangle(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if ((i != 0 || Character.isJavaIdentifierStart(c)) && (i <= 0 || Character.isJavaIdentifierPart(c))) continue;
            cArray[i] = 95;
        }
        return new String(cArray);
    }

    private String getMethodName(String string, Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return this.mangle(string);
        }
        return this.mangle(string + "__" + this.getJVMTypeSignatures(classArray));
    }
}

